/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi.aggregations;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.mhus.lib.core.util.Pair;
import de.otto.flummi.SortOrder;
import de.otto.flummi.aggregations.AggregationBuilder;
import de.otto.flummi.aggregations.AggregationResultParser;
import de.otto.flummi.response.AggregationResult;
import java.util.ArrayList;
import java.util.function.Consumer;

public class TermsBuilder
extends AggregationBuilder<TermsBuilder> {
    private String fieldName;
    private Integer size;
    private ArrayList<Pair<String, SortOrder>> orders;

    public TermsBuilder(String name) {
        super(name);
    }

    public TermsBuilder field(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public TermsBuilder size(int size) {
        this.size = size;
        return this;
    }

    public TermsBuilder order(String fieldName, SortOrder order) {
        if (this.orders == null) {
            this.orders = new ArrayList();
        }
        this.orders.add((Pair<String, SortOrder>)new Pair((Object)fieldName, (Object)order));
        return this;
    }

    @Override
    public JsonObject build() {
        if (this.fieldName == null || this.fieldName.isEmpty()) {
            throw new RuntimeException("missing property 'field'");
        }
        JsonObject jsonObject = new JsonObject();
        JsonObject fields = new JsonObject();
        jsonObject.add("terms", fields);
        fields.add("field", new JsonPrimitive(this.fieldName));
        if (this.size != null) {
            fields.add("size", new JsonPrimitive(this.size));
        }
        if (this.orders != null) {
            JsonObject orderObject = new JsonObject();
            this.orders.forEach((Consumer<Pair<String, SortOrder>>)((Consumer<Pair>)e -> orderObject.add((String)e.getKey(), new JsonPrimitive(((SortOrder)((Object)((Object)e.getValue()))).toString()))));
            fields.add("order", orderObject);
        }
        return jsonObject;
    }

    @Override
    public AggregationResult parseResponse(JsonObject jsonObject) {
        return AggregationResultParser.parseBuckets(jsonObject);
    }

    public JsonElement buildValue() {
        if (this.fieldName == null || this.fieldName.isEmpty()) {
            throw new RuntimeException("missing property 'field'");
        }
        JsonObject fields = new JsonObject();
        fields.add("field", new JsonPrimitive(this.fieldName));
        if (this.size != null) {
            fields.add("size", new JsonPrimitive(this.size));
        }
        if (this.orders != null) {
            JsonObject orderObject = new JsonObject();
            this.orders.forEach((Consumer<Pair<String, SortOrder>>)((Consumer<Pair>)e -> orderObject.add((String)e.getKey(), new JsonPrimitive(((SortOrder)((Object)((Object)e.getValue()))).toString()))));
            fields.add("order", orderObject);
        }
        return fields;
    }
}

