/*
 * Decompiled with CFR 0.152.
 */
package de.otto.flummi;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Response;
import de.otto.flummi.AdminClient;
import de.otto.flummi.InvalidElasticsearchResponseException;
import de.otto.flummi.RequestBuilderUtil;
import de.otto.flummi.request.BulkRequestBuilder;
import de.otto.flummi.request.CountRequestBuilder;
import de.otto.flummi.request.DeleteRequestBuilder;
import de.otto.flummi.request.GetRequestBuilder;
import de.otto.flummi.request.GsonHelper;
import de.otto.flummi.request.IndexRequestBuilder;
import de.otto.flummi.request.MultiGetRequestBuilder;
import de.otto.flummi.request.PingBuilder;
import de.otto.flummi.request.RefreshRequestBuilder;
import de.otto.flummi.request.SearchRequestBuilder;
import de.otto.flummi.request.SearchScrollRequestBuilder;
import de.otto.flummi.util.HttpClientWrapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

public class Flummi {
    private final HttpClientWrapper httpClient;
    private final Gson gson;

    public Flummi(String baseUrl) {
        this(new AsyncHttpClient(), baseUrl);
    }

    public Flummi(AsyncHttpClient asyncHttpClient, String baseUrl) {
        this.httpClient = new HttpClientWrapper(asyncHttpClient, baseUrl);
        this.gson = new Gson();
    }

    public Optional<String> getIndexNameForAlias(String aliasName) {
        try {
            Response response = (Response)this.httpClient.prepareGet("/_aliases").execute().get();
            if (response.getStatusCode() != 200) {
                throw RequestBuilderUtil.toHttpServerErrorException(response);
            }
            String jsonString = response.getResponseBody();
            return this.gson.fromJson(jsonString, JsonObject.class).entrySet().stream().filter(e -> e.getValue() != null && ((JsonElement)e.getValue()).isJsonObject() && ((JsonElement)e.getValue()).getAsJsonObject().get("aliases") != null && ((JsonElement)e.getValue()).getAsJsonObject().get("aliases").isJsonObject() && ((JsonElement)e.getValue()).getAsJsonObject().get("aliases").getAsJsonObject().has(aliasName)).map(e -> (String)e.getKey()).findFirst();
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
        catch (InterruptedException | ExecutionException e3) {
            throw new RuntimeException(e3);
        }
    }

    public void pointProductAliasToCurrentIndex(String aliasName, String indexName) throws InvalidElasticsearchResponseException {
        try {
            JsonArray actions = new JsonArray();
            actions.add(GsonHelper.object("remove", GsonHelper.object("index", "*", "alias", aliasName)));
            actions.add(GsonHelper.object("add", GsonHelper.object("index", indexName, "alias", aliasName)));
            JsonObject jsonObject = GsonHelper.object("actions", actions);
            Response response = (Response)this.httpClient.preparePost("/_aliases").setBody(this.gson.toJson(jsonObject)).execute().get();
            if (response.getStatusCode() >= 300) {
                throw RequestBuilderUtil.toHttpServerErrorException(response);
            }
            JsonObject responseObject = this.gson.fromJson(response.getResponseBody(), JsonObject.class);
            if (!responseObject.has("acknowledged")) {
                throw new InvalidElasticsearchResponseException("Response does not contain field 'acknowledged': " + responseObject);
            }
            if (!responseObject.get("acknowledged").getAsBoolean()) {
                throw new RuntimeException("Pointing product alias to current index not acknowledged");
            }
            return;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean aliasExists(String aliasName) {
        try {
            Response response = (Response)this.httpClient.prepareGet("/_aliases").execute().get();
            if (response.getStatusCode() != 200) {
                throw RequestBuilderUtil.toHttpServerErrorException(response);
            }
            String jsonString = response.getResponseBody();
            JsonObject responseObject = this.gson.fromJson(jsonString, JsonObject.class);
            return responseObject.entrySet().stream().filter(e -> e.getValue() != null && ((JsonElement)e.getValue()).isJsonObject() && ((JsonElement)e.getValue()).getAsJsonObject().get("aliases") != null && ((JsonElement)e.getValue()).getAsJsonObject().get("aliases").isJsonObject() && ((JsonElement)e.getValue()).getAsJsonObject().get("aliases").getAsJsonObject().has(aliasName)).count() > 0L;
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
        catch (InterruptedException e3) {
            throw new RuntimeException(e3);
        }
        catch (ExecutionException e4) {
            throw new RuntimeException(e4);
        }
    }

    public List<String> getAllIndexNames() {
        try {
            Response response = (Response)this.httpClient.prepareGet("/_all").execute().get();
            if (response.getStatusCode() != 200) {
                throw RequestBuilderUtil.toHttpServerErrorException(response);
            }
            String jsonString = response.getResponseBody();
            JsonObject responseObject = this.gson.fromJson(jsonString, JsonObject.class);
            return responseObject.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonObject getIndexSettings() {
        try {
            Response response = (Response)this.httpClient.prepareGet("/_all/_settings").execute().get();
            if (response.getStatusCode() != 200) {
                throw RequestBuilderUtil.toHttpServerErrorException(response);
            }
            String jsonString = null;
            try {
                jsonString = response.getResponseBody();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.gson.fromJson(jsonString, JsonObject.class);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void refreshIndex(String indexName) {
        new RefreshRequestBuilder(this.httpClient, indexName).execute();
    }

    public SearchRequestBuilder prepareSearch(String ... indices) {
        return new SearchRequestBuilder(this.httpClient, indices);
    }

    public CountRequestBuilder prepareCount(String ... indices) {
        return new CountRequestBuilder(this.httpClient, indices);
    }

    public BulkRequestBuilder prepareBulk() {
        return new BulkRequestBuilder(this.httpClient);
    }

    public GetRequestBuilder prepareGet(String indexName, String documentType, String id) {
        return new GetRequestBuilder(this.httpClient, indexName, documentType, id);
    }

    public DeleteRequestBuilder prepareDelete() {
        return new DeleteRequestBuilder(this.httpClient);
    }

    public MultiGetRequestBuilder prepareMultiGet(String[] indices) {
        return new MultiGetRequestBuilder(this.httpClient, indices);
    }

    public SearchScrollRequestBuilder prepareScroll() {
        return new SearchScrollRequestBuilder(this.httpClient);
    }

    public IndexRequestBuilder prepareIndex() {
        return new IndexRequestBuilder(this.httpClient);
    }

    public AdminClient admin() {
        return new AdminClient(this.httpClient);
    }

    public PingBuilder preparePing() {
        return new PingBuilder(this.httpClient);
    }
}

