/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.karaf.mongo.api;

import de.mhus.karaf.mongo.api.MoManagerService;
import de.mhus.lib.adb.query.AQuery;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.util.MUri;
import de.mhus.lib.errors.NotFoundException;
import de.mhus.lib.mongo.MoManager;
import de.mhus.lib.mongo.MoQueryBuilder;
import de.mhus.lib.mongo.xdb.MongoDataSource;
import de.mhus.osgi.api.services.MOsgi;
import dev.morphia.query.Query;
import java.io.IOException;
import java.sql.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.codehaus.jackson.JsonProcessingException;

public class MongoUtil {
    public static MongoDataSource getDatasource(String name) throws NotFoundException {
        return (MongoDataSource)MOsgi.getService(MongoDataSource.class, (String)("(lookup.name=" + name + ")"));
    }

    public static List<MoManagerService> getManagerServices() {
        return MOsgi.getServices(MoManagerService.class, null);
    }

    public static Object prepareAttribute(Class<?> type, Object value) {
        if (value == null || value.equals("[null]")) {
            return null;
        }
        if (value.equals("[uuid]")) {
            return UUID.randomUUID();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.startsWith("[") && str.endsWith("]")) {
                String[] parts = str.substring(1, str.length() - 1).split(",");
                for (int i = 0; i < parts.length; ++i) {
                    parts[i] = MUri.decode((String)parts[i]);
                }
                value = parts;
            } else {
                value = MUri.decode((String)str);
            }
        }
        if (type == value.getClass()) {
            return value;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return MCast.toint((Object)value, (int)0);
        }
        if (type == Long.TYPE || type == Long.class) {
            return MCast.tolong((Object)value, (long)0L);
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(MCast.tofloat((Object)value, (float)0.0f));
        }
        if (type == Double.TYPE || type == Double.class) {
            return MCast.todouble((Object)value, (double)0.0);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return MCast.toboolean((Object)value, (boolean)false);
        }
        if (type == java.util.Date.class) {
            return MCast.toDate((Object)String.valueOf(value), null);
        }
        if (type == Date.class) {
            java.util.Date data = MCast.toDate((Object)String.valueOf(value), null);
            if (data == null) {
                return null;
            }
            return new Date(data.getTime());
        }
        if (type == UUID.class) {
            return UUID.fromString(String.valueOf(value));
        }
        if (type.isEnum()) {
            return String.valueOf(value);
        }
        return null;
    }

    public static <T> Query<T> createQuery(MoManager manager, Class<T> type, String search, Map<String, Object> parameterValues) throws JsonProcessingException, IOException {
        Query q = manager.createQuery(type);
        if (MString.isSet((String)search)) {
            new MoQueryBuilder(search).create(q, parameterValues);
        }
        return q;
    }

    public static <T> Query<T> createQuery(MoManager manager, AQuery<T> query) throws IOException {
        Query q = manager.createQuery(query.getType());
        new MoQueryBuilder(query).create(q, null);
        return q;
    }
}

