/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.karaf.mongo.api;

import com.mongodb.MongoClient;
import de.mhus.lib.core.MLog;
import de.mhus.lib.mongo.xdb.MongoDataSource;

public class MongoConnection
extends MLog
implements MongoDataSource {
    private String name;
    private String host;
    private int port;
    private MongoClient client;

    public MongoConnection(String name, String host, int port) {
        this.name = name;
        this.host = host;
        this.port = port;
    }

    public synchronized MongoClient getConnection() {
        if (this.client == null) {
            this.log().i(new Object[]{"Connect", this.name});
            this.client = new MongoClient(this.host, this.port);
        }
        return this.client;
    }

    public String getName() {
        return this.name;
    }

    public boolean isConnected() {
        return this.client != null;
    }

    public void reset() {
        if (this.client != null) {
            this.client.close();
        }
        this.client = null;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

