/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.liferay.portlet;

import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.util.ParamUtil;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.liferay.portlet.RenderRequestWrapper;
import de.mhus.lib.liferay.portlet.ResourceRequestWrapper;
import de.mhus.lib.portlet.actions.ActionRequestHandler;
import de.mhus.lib.portlet.resource.ResourceRequestHandler;
import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;

public abstract class LiferayMVCPortlet
extends MVCPortlet {
    public static final String PUBLIC_PREFIX = "public_";
    public static final String REASON_ATTRIBUTE_NAME = "reason";
    public static final String INIT_PARAMETER_PUBLIC_VIEW = "public-view-jsp";
    protected ResourceRequestHandler resourcesHandler = new ResourceRequestHandler();
    protected ActionRequestHandler actionsHandler = new ActionRequestHandler();
    protected Log log = Log.getLog(((Object)((Object)this)).getClass());
    protected boolean viewNeedParameters = false;
    private String publicViewTemplate;

    public void init() throws PortletException {
        super.init();
        this.publicViewTemplate = this.getInitParameter(INIT_PARAMETER_PUBLIC_VIEW);
        this.doInit();
    }

    protected abstract void doInit() throws PortletException;

    protected String hasRights(PortletRequest request) {
        return null;
    }

    public void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        String reason;
        if (this.viewNeedParameters) {
            renderRequest = new RenderRequestWrapper(renderRequest);
        }
        if ((reason = this.hasRights((PortletRequest)renderRequest)) != null) {
            renderRequest.setAttribute(REASON_ATTRIBUTE_NAME, (Object)reason);
            this.doPublicView(renderRequest, renderResponse);
            return;
        }
        if (!this.doFillViewAttributes(renderRequest, renderResponse)) {
            return;
        }
        super.doView(renderRequest, renderResponse);
    }

    public void doPublicView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (this.publicViewTemplate != null) {
            this.include(this.publicViewTemplate, renderRequest, renderResponse);
        }
    }

    protected boolean doFillViewAttributes(RenderRequest request, RenderResponse response) throws IOException, PortletException {
        return true;
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String actionName = ParamUtil.getString((PortletRequest)request, (String)"javax.portlet.action");
        if (this.hasRights((PortletRequest)request) != null && !actionName.startsWith(PUBLIC_PREFIX)) {
            return;
        }
        this.log.t(new Object[]{"action", actionName});
        try {
            if (MString.isSet((String)actionName) && this.actionsHandler.processAction(actionName, request, response)) {
                return;
            }
        }
        catch (Exception e) {
            throw new IOException("Action: " + actionName, e);
        }
        try {
            super.processAction(request, response);
        }
        catch (PortletException e) {
            this.log.e(new Object[]{"Action exception", actionName, e.toString()});
            throw e;
        }
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        if (this.hasRights((PortletRequest)resourceRequest) != null && !resourceRequest.getResourceID().startsWith(PUBLIC_PREFIX)) {
            return;
        }
        this.log.t(new Object[]{"resource", resourceRequest.getResourceID()});
        if (this.resourcesHandler.serveResource((ResourceRequest)new ResourceRequestWrapper(resourceRequest), resourceResponse)) {
            return;
        }
        super.serveResource(resourceRequest, resourceResponse);
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (this.hasRights((PortletRequest)request) != null) {
            return;
        }
        super.doEdit(request, response);
    }
}

