/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.liferay.osgi;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.TriggerState;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerResponse;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.CompanyServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.console.ConsoleTable;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Locale;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;

public class CmdLiferayMhus
implements CommandProvider {
    public String getHelp() {
        return "clc - Clear Liferay Cache\nsetpassword - Set New Password <virtual host> <user> <new password> [<need user reset>]";
    }

    public Object _clc(CommandInterpreter intp) {
        intp.println((Object)"Clear Liferay Caches");
        CacheRegistryUtil.clear();
        EntityCacheUtil.clearCache();
        FinderCacheUtil.clearCache();
        return null;
    }

    public Object _virtualhosts(CommandInterpreter ci) throws PortalException {
        ConsoleTable out = new ConsoleTable();
        out.setHeaderValues(new String[]{"Id", "Hostname", "Company Id", "Company Name", "Company Admin"});
        for (VirtualHost vh : VirtualHostLocalServiceUtil.getVirtualHosts((int)0, (int)VirtualHostLocalServiceUtil.getVirtualHostsCount())) {
            long companyId = vh.getCompanyId();
            Company company = CompanyServiceUtil.getCompanyById((long)companyId);
            out.addRowValues(new Object[]{vh.getVirtualHostId(), vh.getHostname(), companyId, company.getName(), company.getAdminName()});
        }
        ci.println((Object)out);
        return null;
    }

    public Object _users(CommandInterpreter ci) throws Exception {
        String virtualHost = ci.nextArgument();
        Company company = CompanyServiceUtil.getCompanyByVirtualHost((String)virtualHost);
        long companyId = company.getCompanyId();
        ConsoleTable out = new ConsoleTable();
        out.setHeaderValues(new String[]{"Id", "Screen Name", "EMail", "Full Name"});
        for (User user : UserLocalServiceUtil.getCompanyUsers((long)companyId, (int)0, (int)UserLocalServiceUtil.getCompanyUsersCount((long)companyId))) {
            out.addRowValues(new Object[]{user.getUserId(), user.getScreenName(), user.getEmailAddress(), user.getFullName()});
        }
        ci.println((Object)out);
        return null;
    }

    public Object _user(CommandInterpreter ci) throws Exception {
        String virtualHost = ci.nextArgument();
        Company company = CompanyServiceUtil.getCompanyByVirtualHost((String)virtualHost);
        String screenName = ci.nextArgument();
        User u = UserLocalServiceUtil.getUserByScreenName((long)company.getCompanyId(), (String)screenName);
        ci.println((Object)("UserId             : " + u.getUserId()));
        ci.println((Object)("UserUUID           : " + u.getUserUuid()));
        ci.println((Object)("ScreenName         : " + u.getScreenName()));
        ci.println((Object)("EMail..............: " + u.getEmailAddress()));
        ci.println((Object)("Display EMail      : " + u.getDisplayEmailAddress()));
        ci.println((Object)("Original EMail     : " + u.getOriginalEmailAddress()));
        ci.println((Object)("Greeting           : " + u.getGreeting()));
        ci.println((Object)("Initials...........: " + u.getInitials()));
        ci.println((Object)("FirstName          : " + u.getFirstName()));
        ci.println((Object)("MiddleName         : " + u.getMiddleName()));
        ci.println((Object)("LastName           : " + u.getLastName()));
        ci.println((Object)("FullName...........: " + u.getFullName()));
        ci.println((Object)("Comments           : " + u.getComments()));
        ci.println((Object)("LastLoginDate      : " + u.getLastLoginDate()));
        ci.println((Object)("LastLoginIP        : " + u.getLastLoginIP()));
        ci.println((Object)("LastFailedLogin....: " + u.getLastFailedLoginDate()));
        ci.println((Object)("FailedLoginAttempts: " + u.getFailedLoginAttempts()));
        ci.println((Object)("IsActive           : " + u.isActive()));
        ci.println((Object)("IsAgreedTermsOfUse : " + u.isAgreedToTermsOfUse()));
        ci.println((Object)("IsMale.............: " + u.isMale()));
        ci.println((Object)("IsFemale           : " + u.isFemale()));
        ci.println((Object)("IsPasswordReset    : " + u.isPasswordReset()));
        ci.println((Object)("ReminderQuestion   : " + u.getReminderQueryQuestion()));
        ci.println((Object)("ReminderAnswer.....: " + u.getReminderQueryAnswer()));
        ci.println((Object)("JobTitle           : " + u.getJobTitle()));
        ci.println();
        for (Group s : GroupLocalServiceUtil.getUserSitesGroups((long)u.getUserId())) {
            ci.println((Object)("Site  : " + s.getGroupId() + " " + s.getFriendlyURL() + " " + s.getName()));
        }
        for (Group s : GroupLocalServiceUtil.getUserGroups((long)u.getUserId())) {
            ci.println((Object)("Group : " + s.getGroupId() + " " + s.getFriendlyURL() + " " + s.getName()));
        }
        return null;
    }

    public Object _groups(CommandInterpreter ci) {
        ConsoleTable out = new ConsoleTable();
        out.setHeaderValues(new String[]{"Id", "Company", "Active", "Site", "URL"});
        for (Group s : GroupLocalServiceUtil.getGroups((int)0, (int)GroupLocalServiceUtil.getGroupsCount())) {
            if (s.isUser()) continue;
            out.addRowValues(new Object[]{s.getGroupId(), s.getCompanyId(), s.getActive(), s.isSite(), s.getFriendlyURL()});
        }
        ci.print((Object)out);
        return null;
    }

    public Object _setpassword(CommandInterpreter ci) throws PortalException {
        try {
            String virtualHost = ci.nextArgument();
            String screenName = ci.nextArgument();
            String pw = ci.nextArgument();
            String reset = ci.nextArgument();
            Company company = CompanyServiceUtil.getCompanyByVirtualHost((String)virtualHost);
            User user = UserLocalServiceUtil.getUserByScreenName((long)company.getCompanyId(), (String)screenName);
            UserLocalServiceUtil.updatePassword((long)user.getUserId(), (String)pw, (String)pw, (boolean)MCast.toboolean((Object)reset, (boolean)false), (boolean)true);
            return null;
        }
        catch (Throwable t) {
            ci.printStackTrace(t);
            throw t;
        }
    }

    public Object _roles(CommandInterpreter ci) throws PortalException {
        String virtualHost = ci.nextArgument();
        Company company = CompanyServiceUtil.getCompanyByVirtualHost((String)virtualHost);
        ConsoleTable out = new ConsoleTable();
        out.setHeaderValues(new String[]{"Id", "Name", "Type", "Title", "User Id", "User Name"});
        for (Role role : RoleLocalServiceUtil.getRoles((long)company.getCompanyId())) {
            out.addRowValues(new Object[]{role.getRoleId(), role.getName(), role.getTypeLabel(), role.getTitle(), role.getUserId(), role.getUserName()});
        }
        ci.println((Object)out);
        return null;
    }

    @Transactional
    public Object _role_delete(CommandInterpreter ci) throws PortalException {
        long id = MCast.tolong((Object)ci.nextArgument(), (long)-1L);
        if (id < 0L) {
            return null;
        }
        Role role = RoleLocalServiceUtil.deleteRole((long)id);
        ci.println((Object)("Deleted Role " + role.getRoleId() + " " + role.getName()));
        return role;
    }

    public Object _companies(CommandInterpreter ci) throws PortalException {
        ConsoleTable out = new ConsoleTable();
        out.setHeaderValues(new String[]{"Id", "Active", "Name", "AccoutnId", "DefaultUser", "DefaultWebId", "GroupId", "Mx"});
        for (Company c : CompanyLocalServiceUtil.getCompanies()) {
            out.addRowValues(new Object[]{c.getCompanyId(), c.getActive(), c.getName(), c.getAccountId(), c.getDefaultUser().getUserId(), c.getDefaultWebId(), c.getGroupId(), c.getMx()});
        }
        ci.println((Object)out);
        return null;
    }

    public Object _company(CommandInterpreter ci) throws PortalException {
        long id = MCast.tolong((Object)ci.nextArgument(), (long)-1L);
        Company c = CompanyLocalServiceUtil.getCompany((long)id);
        ci.println((Object)c.toXmlString());
        return null;
    }

    @Transactional
    public Object _user_delete(CommandInterpreter ci) throws PortalException {
        long id = MCast.tolong((Object)ci.nextArgument(), (long)-1L);
        if (id < 0L) {
            return null;
        }
        User user = UserLocalServiceUtil.deleteUser((long)id);
        ci.println((Object)("Deleted User " + user.getUserId() + " " + user.getScreenName()));
        return user;
    }

    public Object _user_add(CommandInterpreter ci) throws PortalException {
        try {
            String virtualHost = ci.nextArgument();
            Company company = CompanyServiceUtil.getCompanyByVirtualHost((String)virtualHost);
            String screenName = ci.nextArgument();
            String email = ci.nextArgument();
            String firstName = ci.nextArgument();
            String lastName = ci.nextArgument();
            User user = UserLocalServiceUtil.addUser((long)0L, (long)company.getCompanyId(), (boolean)false, (String)"asd", (String)"asd", (boolean)false, (String)screenName, (String)email, (long)0L, null, (Locale)Locale.GERMAN, (String)firstName, (String)"", (String)lastName, (long)0L, (long)0L, (boolean)true, (int)1, (int)1, (int)1970, (String)"", (long[])new long[0], (long[])new long[0], (long[])new long[0], (long[])new long[0], (boolean)false, null);
            return user;
        }
        catch (Throwable t) {
            ci.printStackTrace(t);
            throw t;
        }
    }

    @Transactional
    public Object _user_set(CommandInterpreter ci) throws PortalException {
        try {
            String pair;
            String virtualHost = ci.nextArgument();
            Company company = CompanyServiceUtil.getCompanyByVirtualHost((String)virtualHost);
            String screenName = ci.nextArgument();
            User u = UserLocalServiceUtil.getUserByScreenName((long)company.getCompanyId(), (String)screenName);
            block30: while ((pair = ci.nextArgument()) != null) {
                if (!MString.isIndex((String)pair, (char)'=')) continue;
                String key = MString.beforeIndex((String)pair, (char)'=');
                String val = MString.afterIndex((String)pair, (char)'=');
                switch (key = key.toLowerCase().trim()) {
                    case "screenname": {
                        u.setScreenName(val);
                        continue block30;
                    }
                    case "email": {
                        u.setEmailAddress(val);
                        continue block30;
                    }
                    case "greeting": {
                        u.setGreeting(val);
                        continue block30;
                    }
                    case "firstname": {
                        u.setFirstName(val);
                        continue block30;
                    }
                    case "middlename": {
                        u.setMiddleName(val);
                        continue block30;
                    }
                    case "lastname": {
                        u.setLastName(val);
                        continue block30;
                    }
                    case "comments": {
                        u.setComments(val);
                        continue block30;
                    }
                    case "lastlogindate": {
                        u.setLastLoginDate(MCast.toDate((Object)val, null));
                        continue block30;
                    }
                    case "lastloginip": {
                        u.setLastLoginIP(val);
                        continue block30;
                    }
                    case "isagreedtermsofuse": {
                        u.setAgreedToTermsOfUse(MCast.toboolean((Object)val, (boolean)false));
                        continue block30;
                    }
                    case "ispasswordreset": {
                        u.setPasswordReset(MCast.toboolean((Object)val, (boolean)false));
                        continue block30;
                    }
                    case "jobtitle": {
                        u.setJobTitle(val);
                        continue block30;
                    }
                }
                ci.println((Object)("Unknown parameter: " + key));
            }
            UserLocalServiceUtil.updateUser((User)u);
            ci.println((Object)("UPDATED " + u));
            return u;
        }
        catch (Throwable t) {
            ci.printStackTrace(t);
            throw t;
        }
    }

    @Transactional
    public Object _role_add(CommandInterpreter ci) throws PortalException {
        String virtualHost = ci.nextArgument();
        Company company = CompanyServiceUtil.getCompanyByVirtualHost((String)virtualHost);
        String userName = ci.nextArgument();
        User user = UserLocalServiceUtil.getUserByScreenName((long)company.getCompanyId(), (String)userName);
        String name = ci.nextArgument();
        Role role = RoleLocalServiceUtil.addRole((long)user.getUserId(), null, (long)0L, (String)name, null, null, (int)0, null, null);
        return role;
    }

    public Object _db_commit(CommandInterpreter ci) throws SQLException {
        Connection con = DataAccess.getConnection();
        con.commit();
        return null;
    }

    public Object _db_rollback(CommandInterpreter ci) throws SQLException {
        Connection con = DataAccess.getConnection();
        con.rollback();
        return null;
    }

    public Object _db_tables(CommandInterpreter ci) throws SQLException {
        Connection con = DataAccess.getConnection();
        DatabaseMetaData meta = con.getMetaData();
        ResultSet res = meta.getTables(null, null, null, new String[]{"TABLE"});
        ConsoleTable out = ConsoleTable.fromJdbcResult((ResultSet)res);
        ci.println((Object)out);
        return null;
    }

    public Object _db_table(CommandInterpreter ci) throws SQLException {
        String name = ci.nextArgument();
        Connection con = DataAccess.getConnection();
        DatabaseMetaData meta = con.getMetaData();
        ResultSet res = meta.getColumns(null, null, name, "%");
        ConsoleTable out = ConsoleTable.fromJdbcResult((ResultSet)res);
        ci.println((Object)out);
        return null;
    }

    public Object _db_indexes(CommandInterpreter ci) throws SQLException {
        String idxName = ci.nextArgument();
        Connection con = DataAccess.getConnection();
        DatabaseMetaData meta = con.getMetaData();
        ResultSet tres = meta.getTables(null, null, null, new String[]{"TABLE"});
        ConsoleTable out = null;
        while (tres.next()) {
            int i;
            ResultSet res = meta.getIndexInfo(con.getCatalog(), null, tres.getString("TABLE_NAME"), true, false);
            ResultSetMetaData resMeta = res.getMetaData();
            if (out == null) {
                out = new ConsoleTable();
                String[] h = new String[resMeta.getColumnCount()];
                for (i = 0; i < resMeta.getColumnCount(); ++i) {
                    h[i] = resMeta.getColumnName(i + 1);
                }
                out.setHeaderValues(h);
            }
            while (res.next()) {
                if (idxName != null && !idxName.equals(res.getString("INDEX_NAME"))) continue;
                ConsoleTable.Row r = out.addRow();
                for (i = 0; i < resMeta.getColumnCount(); ++i) {
                    r.add((Object)String.valueOf(res.getObject(i + 1)));
                }
            }
        }
        ci.println(out);
        return null;
    }

    public Object _db_select(CommandInterpreter ci) throws SQLException {
        String sql = ci.nextArgument();
        Connection con = DataAccess.getConnection();
        Statement sth = con.createStatement();
        ResultSet res = sth.executeQuery(sql);
        ConsoleTable out = ConsoleTable.fromJdbcResult((ResultSet)res);
        sth.close();
        ci.println((Object)out);
        return null;
    }

    public Object _db_update(CommandInterpreter ci) throws SQLException {
        String sql = ci.nextArgument();
        Connection con = DataAccess.getConnection();
        Statement sth = con.createStatement();
        int res = sth.executeUpdate(sql);
        ci.println((Object)("Result: " + res));
        return null;
    }

    public Object _jobs(CommandInterpreter ci) throws SchedulerException {
        ConsoleTable out = new ConsoleTable();
        out.setHeaderValues(new String[]{"Name", "Group", "Storage Type", "Next", "State"});
        for (SchedulerResponse job : SchedulerEngineHelperUtil.getScheduledJobs()) {
            Date next = SchedulerEngineHelperUtil.getNextFireTime((String)job.getJobName(), (String)job.getGroupName(), (StorageType)job.getStorageType());
            TriggerState state = SchedulerEngineHelperUtil.getJobState((String)job.getJobName(), (String)job.getGroupName(), (StorageType)job.getStorageType());
            out.addRowValues(new Object[]{job.getJobName(), job.getGroupName(), job.getStorageType(), next, state});
        }
        ci.println((Object)out);
        return null;
    }

    public Object _config_info(CommandInterpreter ci) throws SchedulerException {
        ci.println((Object)new File(".").getAbsolutePath());
        ci.println((Object)MApi.get().getCfgManager());
        return null;
    }

    public Object _dirty_trace(CommandInterpreter ci) throws SchedulerException {
        MApi.setDirtyTrace((boolean)MCast.toboolean((Object)ci.nextArgument(), (boolean)false));
        ci.println((Object)("DirtyTrace: " + MApi.isDirtyTrace()));
        return null;
    }

    public Object _config_reset(CommandInterpreter ci) throws SchedulerException {
        MApi.get().getCfgManager().reConfigure();
        ci.println((Object)"OK");
        return null;
    }
}

