/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.liferay;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.List;
import javax.portlet.PortletRequest;

public class MLiferayUtil {
    public static final String ROLE_ADMINISTRATOR = "Administrator";
    public static final String ROLE_GUEST = "Guest";
    public static final String ROLE_OWNER = "Owner";
    public static final String ROLE_POWER_USER = "Power User";
    public static final String ROLE_SITE_MEMBER = "Site Member";
    public static final String ROLE_SITE_OWNER = "Site Owner";
    public static final String ROLE_SITE_ADMINISTRATOR = "Site Administrator";
    public static final String ROLE_SITE_CONTENT_REVIEWER = "Site Content Reviewer";
    public static final String ROLE_PORTAL_CONTENT_REVIEWER = "Portal Content Reviewer";
    public static final String ROLE_USER = "User";
    public static final String ROLE_ORGANIZATION_OWNER = "Organization Owner";
    public static final String ROLE_ORGANIZATION_USER = "Organization User";
    public static final String ROLE_ORGANIZATION_ADMINISTRATOR = "Organization Administrator";
    public static final String ROLE_ORGANIZATION_CONTENT_REVIEWER = "Organization Content Reviewer";

    public static boolean hasRole(User user, String role) throws SystemException {
        if (user == null || role == null) {
            return false;
        }
        for (Role r : user.getRoles()) {
            if (!r.getName().equals(role)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasRole(User user, List<String> roles) throws SystemException {
        if (user == null || roles == null) {
            return false;
        }
        for (Role r : user.getRoles()) {
            for (String role : roles) {
                if (role == null || !r.getName().equals(role)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getWebUrlForFriendlyUrl(PortletRequest request, String friendly, String attributes) {
        String url = null;
        if (friendly == null) {
            friendly = "/";
        } else if (!friendly.startsWith("/")) {
            friendly = "/" + friendly;
        }
        if (request != null) {
            try {
                ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                long groupId = MLiferayUtil.getCompanyGroupId(request);
                Layout childLayout = LayoutLocalServiceUtil.getFriendlyURLLayout((long)groupId, (boolean)false, (String)friendly);
                url = PortalUtil.getLayoutURL((Layout)childLayout, (ThemeDisplay)themeDisplay);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (url == null) {
            url = "/web/guest" + friendly;
        }
        if (attributes != null) {
            url = url + (url.indexOf(63) > 0 ? "&" : "?") + attributes;
        }
        return url;
    }

    public static long getCompanyGroupId(PortletRequest request) {
        return 10181L;
    }
}

