/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.util;

import java.awt.Color;
import java.awt.Container;
import java.awt.TextArea;

public class VersionCheck {
    static final boolean DEBUGGING = false;

    public static boolean isJavaVersionOK(int wantedMajor, int wantedMinor, int wantedBugFix) {
        try {
            try {
                int gotMinor;
                char ch;
                int gotMajor;
                String ver = System.getProperty("java.version");
                if (ver == null) {
                    return false;
                }
                if ((ver = ver.trim()).length() < 2) {
                    return false;
                }
                int dex = ver.indexOf(46);
                if (dex < 0) {
                    ver = ver.charAt(0) + 46 + ver.substring(1);
                    dex = 1;
                }
                if ((gotMajor = Integer.parseInt(ver.substring(0, dex))) < wantedMajor) {
                    return false;
                }
                if (gotMajor > wantedMajor) {
                    return true;
                }
                if ((ver = ver.substring(dex + 1)).endsWith("beta")) {
                    ver = ver.substring(0, ver.length() - "beta".length());
                }
                if (ver.endsWith("-rc")) {
                    ver = ver.substring(0, ver.length() - "-rc".length());
                }
                if ((dex = ver.lastIndexOf(95)) >= 0) {
                    ver = ver.substring(0, dex);
                }
                if (!Character.isDigit(ch = ver.charAt(ver.length() - 1))) {
                    ver = ver.substring(0, ver.length() - 1);
                    if (ch == 'x' || ch == 'X') {
                        ver = ver + '9';
                    }
                }
                if ((dex = ver.indexOf(46)) < 0) {
                    ver = ver + ".0";
                    dex = ver.indexOf(46);
                }
                if ((gotMinor = Integer.parseInt(ver.substring(0, dex))) < wantedMinor) {
                    return false;
                }
                if (gotMinor > wantedMinor) {
                    return true;
                }
                int gotBugFix = Integer.parseInt(ver = ver.substring(dex + 1));
                return gotBugFix >= wantedBugFix;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            return false;
        }
    }

    public static boolean isJavaVersionOK(int wantedMajor, int wantedMinor, int wantedBugFix, Container container) {
        if (VersionCheck.isJavaVersionOK(wantedMajor, wantedMinor, wantedBugFix)) {
            return true;
        }
        String error = "Error: You need Java " + wantedMajor + "." + wantedMinor + "." + wantedBugFix + " or later to run this Applet.\n" + "You are currently running under Java " + System.getProperty("java.version") + ".\n" + "Get the latest Java from http://java.com/en/index.jsp";
        TextArea complain = new TextArea(error, 3, 42, 3);
        complain.setEditable(false);
        complain.setBackground(Color.white);
        complain.setForeground(Color.red);
        complain.setSize(300, 50);
        container.setLayout(null);
        container.add(complain);
        System.err.println(error);
        return false;
    }

    private VersionCheck() {
    }
}

