/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.util;

import de.mhus.lib.MCast;
import java.util.Map;
import java.util.TreeMap;

public class Rfc1738
extends TreeMap<String, String> {
    private static final long serialVersionUID = -3321101084525120985L;

    @Override
    public void put(String _key, int _value) {
        this.put(_key, MCast.toString(_value));
    }

    public int getInt(String _key, int _def) {
        String v = (String)this.get(_key);
        if (v == null) {
            return _def;
        }
        return MCast.toint(v, 0);
    }

    public int getInt(String _key) {
        return this.getInt(_key, -1);
    }

    @Override
    public String toString() {
        return Rfc1738.implode(this);
    }

    public static String decode(String _in) {
        if (_in == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int mode = 0;
        int buffer = 0;
        for (int i = 0; i < _in.length(); ++i) {
            char c = _in.charAt(i);
            if (mode == 0) {
                if (c == '%') {
                    mode = 1;
                    buffer = 0;
                    continue;
                }
                if (c == '+') {
                    sb.append(' ');
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (mode == 1) {
                if (c >= '0' && c <= '9') {
                    buffer = c - 48;
                } else if (c >= 'A' && c <= 'F') {
                    buffer = c + 10 - 65;
                } else if (c >= 'a' && c <= 'f') {
                    buffer = c + 10 - 97;
                }
                mode = 2;
                continue;
            }
            if (mode != 2) continue;
            buffer *= 16;
            if (c >= '0' && c <= '9') {
                buffer += c - 48;
            } else if (c >= 'A' && c <= 'F') {
                buffer += c + 10 - 65;
            } else if (c >= 'a' && c <= 'f') {
                buffer += c + 10 - 97;
            }
            sb.append((char)buffer);
            mode = 0;
        }
        return sb.toString();
    }

    public static String encode(String _in) {
        if (_in == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int buffer = 0;
        for (int i = 0; i < _in.length(); ++i) {
            char c = _in.charAt(i);
            if (c == '%' || c == '&' || c == '=' || c == '+' || c == '\n' || c == '\r' || c == '?') {
                sb.append('%');
                char cc = c;
                buffer = cc / 16;
                if (buffer < 10) {
                    sb.append((char)(48 + buffer));
                } else {
                    sb.append((char)(55 + buffer));
                }
                buffer = cc % 16;
                if (buffer < 10) {
                    sb.append((char)(48 + buffer));
                    continue;
                }
                sb.append((char)(55 + buffer));
                continue;
            }
            if (c == ' ') {
                sb.append('+');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String implodeArray(String[] in) {
        if (in == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (String i : in) {
            if (!first) {
                sb.append('&');
            }
            sb.append(Rfc1738.encode(i));
            first = false;
        }
        return sb.toString();
    }

    public static String[] explodeArray(String in) {
        if (in == null || in.length() == 0) {
            return new String[0];
        }
        String[] out = in.split("&");
        for (int i = 0; i < out.length; ++i) {
            out[i] = Rfc1738.decode(out[i]);
        }
        return out;
    }

    public static Map<String, String> explode(String _in) {
        if (_in == null) {
            return new TreeMap<String, String>();
        }
        TreeMap<String, String> out = new TreeMap<String, String>();
        String[] obj = _in.split("&");
        for (int i = 0; i < obj.length; ++i) {
            String[] kv = obj[i].split("=");
            if (kv.length == 2) {
                if (kv[1] == null) {
                    kv[1] = "";
                }
                out.put(Rfc1738.decode(kv[0]), Rfc1738.decode(kv[1]));
                continue;
            }
            if (kv.length != 1) continue;
            out.put(Rfc1738.decode(kv[0]), "");
        }
        return out;
    }

    public static String implode(Map<String, String> _in) {
        if (_in == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (String key : _in.keySet()) {
            String value = _in.get(key);
            if (value == null) continue;
            if (!first) {
                sb.append('&');
            }
            sb.append(Rfc1738.encode(key));
            sb.append('=');
            sb.append(Rfc1738.encode(value));
            first = false;
        }
        return sb.toString();
    }
}

