/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.util;

import de.mhus.lib.MActivator;
import de.mhus.lib.MProperties;
import de.mhus.lib.MSingleton;
import de.mhus.lib.logging.Log;
import de.mhus.lib.parser.StringCompiler;
import de.mhus.lib.resources.ActivatorResourceProvider;
import de.mhus.lib.resources.MResources;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class MNls
extends MProperties {
    private static Log log = Log.getLog(MNls.class);

    public MNls() {
    }

    public MNls(MResources res, Class<?> owner) {
        this(res, owner, null);
    }

    public MNls(MResources res, Class<?> owner, String resourceName) {
        this.load(res, owner, resourceName, null);
    }

    public MNls(MActivator act, Class<?> owner, String resourceName) {
        MResources res = null;
        if (act != null) {
            try {
                res = new MResources();
                res.registerProvider("", new ActivatorResourceProvider(act));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.load(res, owner, resourceName, null);
    }

    public void load(MResources res, Class<?> owner, String resourceName, String locale) {
        try {
            if (res == null) {
                res = MSingleton.instance().getResources();
            }
            if (resourceName == null) {
                resourceName = owner.getCanonicalName().replace('.', '/');
            }
            if (res == null) {
                return;
            }
            if (locale == null) {
                locale = this.getDefaultLocale();
            }
            InputStream is = null;
            is = res.getInputStream(resourceName + "_" + locale.toString() + ".properties");
            if (is == null) {
                is = res.getInputStream(resourceName + "_" + this.getDefaultLocale() + ".properties");
            }
            if (is == null) {
                is = res.getInputStream(resourceName + ".properties");
            }
            if (is != null) {
                log.t("Load Resource", resourceName, locale);
                this.properties.load(is);
                is.close();
            } else {
                log.d("Resource not found", resourceName, locale);
            }
        }
        catch (Exception e) {
            log.info(e);
        }
    }

    public String getDefaultLocale() {
        return Locale.getDefault().toString();
    }

    public String find(String in, String ... strings) {
        HashMap<String, Object> attr = new HashMap<String, Object>();
        for (int i = 0; i < strings.length; ++i) {
            attr.put(String.valueOf(i), strings[i]);
        }
        return this.find(in, attr);
    }

    public String find(String in) {
        return this.find(in, (Map<String, Object>)null);
    }

    public String find(String in, Map<String, Object> attributes) {
        String def = null;
        if (in == null) {
            return "";
        }
        int pos = in.indexOf("=");
        if (pos == 0) {
            return in.substring(1);
        }
        if (pos > 0) {
            def = in.substring(pos + 1);
            in = in.substring(0, pos);
        }
        String ret = this.getString(in, def);
        if (attributes != null && ret.indexOf(36) >= 0) {
            ret = StringCompiler.compile(ret).execute(attributes);
        }
        return ret;
    }
}

