/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;

public class FlatteningIterator<E>
implements Iterator<E> {
    private final Object blank = new Object();
    private final Stack<Iterator<?>> iterators = new Stack();
    private Object next = this.blank;

    public FlatteningIterator(Object ... objects) {
        this.iterators.push(Arrays.asList(objects).iterator());
    }

    @Override
    public void remove() {
    }

    private void moveToNext() {
        if (this.next == this.blank && !this.iterators.empty()) {
            if (!this.iterators.peek().hasNext()) {
                this.iterators.pop();
                this.moveToNext();
            } else {
                Object next = this.iterators.peek().next();
                if (next instanceof Iterator) {
                    this.iterators.push((Iterator)next);
                    this.moveToNext();
                } else if (next instanceof Iterable) {
                    this.iterators.push(((Iterable)next).iterator());
                    this.moveToNext();
                } else if (next instanceof Array) {
                    this.iterators.push(Arrays.asList((Array)next).iterator());
                    this.moveToNext();
                } else {
                    this.next = next;
                }
            }
        }
    }

    @Override
    public E next() {
        this.moveToNext();
        if (this.next == this.blank) {
            throw new NoSuchElementException();
        }
        Object next = this.next;
        this.next = this.blank;
        return (E)next;
    }

    @Override
    public boolean hasNext() {
        this.moveToNext();
        return this.next != this.blank;
    }
}

