/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.sql.parser;

import de.mhus.lib.MCast;
import de.mhus.lib.MDate;
import de.mhus.lib.MSql;
import de.mhus.lib.parser.CompiledString;
import de.mhus.lib.parser.ParseException;
import de.mhus.lib.parser.ParseReader;
import de.mhus.lib.parser.Parser;
import de.mhus.lib.parser.ParsingPart;
import de.mhus.lib.parser.StringPart;
import de.mhus.lib.sql.parser.FunctionPart;
import de.mhus.lib.sql.parser.ICompiler;
import de.mhus.lib.sql.parser.MainPart;
import java.io.IOException;
import java.io.StringReader;

public class SqlCompiler
implements Parser,
ICompiler {
    private ICompiler compiler = null;

    public SqlCompiler() {
        this.compiler = this;
    }

    public SqlCompiler(ICompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public CompiledString compileString(String in) throws ParseException {
        ParseReader pr;
        MainPart root = new MainPart(this.compiler);
        StringReader sr = new StringReader(in);
        try {
            pr = new ParseReader(sr);
        }
        catch (IOException e) {
            throw new ParseException(new Object[]{e});
        }
        root.parse(pr);
        return new CompiledString(new StringPart[]{root});
    }

    @Override
    public boolean isParseAttributes() {
        return true;
    }

    @Override
    public ParsingPart compileFunction(FunctionPart function) {
        return function;
    }

    public void setCompiler(ICompiler compiler) {
        this.compiler = compiler;
    }

    public ICompiler getCompiler() {
        return this.compiler;
    }

    @Override
    public String toSqlDateValue(MDate date) {
        return "'" + date.toString() + "'";
    }

    @Override
    public String valueToString(Object value) {
        return MCast.objectToString(value);
    }

    @Override
    public String escape(String text) {
        return MSql.escape(text);
    }
}

