/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.sql.parser;

import de.mhus.lib.MCast;
import de.mhus.lib.MDate;
import de.mhus.lib.MString;
import de.mhus.lib.lang.Raw;
import de.mhus.lib.logging.Log;
import de.mhus.lib.parser.ParseException;
import de.mhus.lib.parser.ParseReader;
import de.mhus.lib.parser.StringParsingPart;
import de.mhus.lib.sql.DbStatement;
import de.mhus.lib.sql.parser.ICompiler;
import de.mhus.lib.util.FallbackMap;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParameterPart
extends StringParsingPart {
    private static Log log = Log.getLog(ParameterPart.class);
    private StringBuffer buffer;
    public String[] attribute;
    private ICompiler compiler;

    public ParameterPart(ICompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void execute(StringBuffer out, Map<String, Object> attributes) {
        Object value = attributes.get(this.attribute[0]);
        if (value == null) {
            out.append("null");
            return;
        }
        if (value.getClass().isArray()) {
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            FallbackMap<String, Object> proxyMap = new FallbackMap<String, Object>(valueMap, attributes, false);
            for (int i = 0; i < ((Object[])value).length; ++i) {
                if (i != 0) {
                    out.append(this.attribute.length > 2 ? this.attribute[2] : ",");
                }
                valueMap.put(this.attribute[0], ((Object[])value)[i]);
                this.execute(out, proxyMap);
            }
            return;
        }
        if (value instanceof List) {
            HashMap valueMap = new HashMap();
            FallbackMap<String, Object> proxyMap = new FallbackMap<String, Object>(valueMap, attributes, false);
            boolean first = true;
            for (Object obj : (List)value) {
                if (!first) {
                    out.append(this.attribute.length > 2 ? this.attribute[2] : ",");
                }
                valueMap.put(this.attribute[0], obj);
                this.execute(out, proxyMap);
                first = false;
            }
            return;
        }
        if (value instanceof InputStream) {
            out.append("?");
            DbStatement.addBinary(attributes, value);
            return;
        }
        String type = null;
        if (this.attribute.length > 1 && !MString.isEmptyTrim(this.attribute[1])) {
            type = this.attribute[1];
        } else if (value instanceof Number || value instanceof Raw) {
            type = "raw";
        } else if (value instanceof java.util.Date || value instanceof Calendar || value instanceof MDate || value instanceof Date) {
            type = "date";
        } else if (value instanceof Boolean) {
            type = "bool";
        } else if (value instanceof Enum) {
            type = "int";
        }
        if (type == null) {
            type = "text";
        }
        log.t(type, value);
        if ("text".equals(type) || "string".equals(type)) {
            out.append("'").append(this.compiler.escape(String.valueOf(value))).append("'");
        } else if ("int".equals(type)) {
            if (value instanceof Enum) {
                out.append(this.compiler.valueToString(((Enum)value).ordinal()));
            } else {
                out.append(this.compiler.valueToString(MCast.toint(value.toString(), 0)));
            }
        } else if ("long".equals(type)) {
            out.append(this.compiler.valueToString(MCast.tolong(value.toString(), 0L)));
        } else if ("float".equals(type)) {
            out.append(this.compiler.valueToString(Float.valueOf(MCast.tofloat(value.toString(), 0.0f))));
        } else if ("double".equals(type)) {
            out.append(this.compiler.valueToString(MCast.todouble(value.toString(), 0.0)));
        } else if ("date".equals(type)) {
            out.append(this.compiler.toSqlDateValue(new MDate(value)));
        } else if ("raw".equals(type)) {
            out.append(this.compiler.valueToString(value));
        } else if ("bool".equals(type)) {
            out.append(MCast.toboolean(value.toString(), false) ? "1" : "0");
        } else {
            log.warn("Unknown attribute type: " + type);
        }
    }

    @Override
    public void doPreParse() {
        this.buffer = new StringBuffer();
    }

    @Override
    public void doPostParse() {
        this.attribute = MString.split(this.buffer.toString(), ",");
        this.buffer = null;
    }

    @Override
    public boolean parse(char c, ParseReader str) throws ParseException, IOException {
        str.consume();
        if (c == '$') {
            return false;
        }
        this.buffer.append(c);
        return true;
    }

    @Override
    public void dump(int level, StringBuffer out) {
        MString.appendRepeating(level, ' ', out);
        out.append(this.getClass().getCanonicalName()).append(this.attribute).append("\n");
    }
}

