/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.sql.parser;

import de.mhus.lib.MString;
import de.mhus.lib.parser.ConstantPart;
import de.mhus.lib.parser.ParseException;
import de.mhus.lib.parser.ParseReader;
import de.mhus.lib.parser.ParsingPart;
import de.mhus.lib.parser.StringParsingPart;
import de.mhus.lib.sql.parser.ConstWordPart;
import de.mhus.lib.sql.parser.FunctionPart;
import de.mhus.lib.sql.parser.ICompiler;
import de.mhus.lib.sql.parser.NumberPart;
import de.mhus.lib.sql.parser.OnePart;
import de.mhus.lib.sql.parser.ParameterPart;
import de.mhus.lib.sql.parser.QuotPart;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;

public class MainPart
extends StringParsingPart {
    private LinkedList<ParsingPart> parts = new LinkedList();
    private boolean stopOnComma;
    private int brakCount;
    private ParsingPart last;
    private boolean parseAttributes = true;
    private ICompiler compiler;

    public MainPart(ICompiler compiler) {
        this.compiler = compiler;
        this.setParseAttributes(compiler.isParseAttributes());
    }

    @Override
    public void execute(StringBuffer out, Map<String, Object> attributes) {
        for (ParsingPart p : this.parts) {
            p.execute(out, attributes);
        }
    }

    public void add(ParsingPart pp) {
        this.parts.add(pp);
        this.last = pp;
    }

    @Override
    public void doPreParse() {
    }

    @Override
    public void doPostParse() {
    }

    @Override
    public boolean parse(char c, ParseReader str) throws ParseException, IOException {
        if (this.stopOnComma && (c == ',' || c == ')' && this.brakCount == 0)) {
            return false;
        }
        if (this.stopOnComma && c == '(') {
            OnePart pp = new OnePart(this.compiler);
            this.add(pp);
            pp.parse(str);
            ++this.brakCount;
            return true;
        }
        if (this.stopOnComma && c == ')') {
            OnePart pp = new OnePart(this.compiler);
            this.add(pp);
            pp.parse(str);
            --this.brakCount;
            return true;
        }
        if (c >= '0' && c <= '9') {
            NumberPart pp = new NumberPart(this.compiler);
            this.add(pp);
            pp.parse(str);
            return true;
        }
        if (c == '-' || c == '+' || c == '(' || c == ')' || c == ' ' || c == '\n' || c == '\r' || c == '\t' || c == '*' || c == '=' || c == '>' || c == '<' || c == '!' || c == '/' || c == ',') {
            if (this.last != null && this.last instanceof OnePart) {
                ((OnePart)this.last).append(c);
                str.consume();
            } else {
                OnePart pp = new OnePart(this.compiler);
                this.add(pp);
                pp.parse(str);
            }
            return true;
        }
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_') {
            ConstWordPart pp = new ConstWordPart(this.compiler);
            pp.parse(str);
            if (!str.isClosed() && str.character() == '(') {
                ParsingPart pp2 = new FunctionPart(this.compiler, pp.getContent());
                str.consume();
                pp2.parse(str);
                pp2 = this.compiler.compileFunction((FunctionPart)pp2);
                this.add(pp2);
            } else {
                this.add(pp);
            }
            return true;
        }
        if (c == '\'') {
            QuotPart pp = new QuotPart(this.compiler);
            this.add(pp);
            pp.parse(str);
            return true;
        }
        if (this.isParseAttributes() && c == '$') {
            str.consume();
            if (str.isClosed()) {
                this.add(new ConstantPart(this.compiler, "$"));
                return false;
            }
            if (str.character() == '$') {
                str.consume();
                this.add(new ConstantPart(this.compiler, "$"));
                return true;
            }
            ParameterPart pp = new ParameterPart(this.compiler);
            this.add(pp);
            pp.parse(str);
            return true;
        }
        throw new ParseException("unknown character", Character.valueOf(c), str.getPosition());
    }

    @Override
    public void dump(int level, StringBuffer out) {
        MString.appendRepeating(level, ' ', out);
        out.append(this.getClass().getCanonicalName()).append(" (").append("\n");
        for (ParsingPart p : this.parts) {
            p.dump(level + 1, out);
        }
        MString.appendRepeating(level, ' ', out);
        out.append(")").append("\n");
    }

    public void setStopOnComma(boolean b) {
        this.stopOnComma = b;
    }

    public void setParseAttributes(boolean parseAttributes) {
        this.parseAttributes = parseAttributes;
    }

    public boolean isParseAttributes() {
        return this.parseAttributes;
    }
}

