/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.sql.parser;

import de.mhus.lib.MString;
import de.mhus.lib.parser.ParseException;
import de.mhus.lib.parser.ParseReader;
import de.mhus.lib.parser.ParsingPart;
import de.mhus.lib.sql.parser.ICompiler;
import de.mhus.lib.sql.parser.MainPart;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;

public class FunctionPart
implements ParsingPart {
    private String name;
    private LinkedList<ParsingPart> parts = new LinkedList();
    private ICompiler compiler;

    public FunctionPart(ICompiler compiler, String name) {
        this.compiler = compiler;
        this.name = name;
    }

    @Override
    public void execute(StringBuffer out, Map<String, Object> attributes) {
        out.append(this.name).append("(");
        boolean first = true;
        for (ParsingPart p : this.parts) {
            if (!first) {
                out.append(",");
            }
            p.execute(out, attributes);
            first = false;
        }
        out.append(")");
    }

    @Override
    public void dump(int level, StringBuffer out) {
        MString.appendRepeating(level, ' ', out);
        out.append(this.getClass().getCanonicalName()).append(" ").append(this.name).append(" (").append("\n");
        for (ParsingPart p : this.parts) {
            p.dump(level + 1, out);
        }
        MString.appendRepeating(level, ' ', out);
        out.append(")").append("\n");
    }

    @Override
    public void parse(ParseReader str) throws ParseException {
        try {
            while (true) {
                this.removeSpaces(str);
                MainPart pp = new MainPart(this.compiler);
                pp.setStopOnComma(true);
                pp.parse(str);
                this.add(pp);
                if (str.character() == ')') {
                    str.consume();
                    return;
                }
                if (str.character() != ',') continue;
                str.consume();
            }
        }
        catch (IOException e) {
            throw new ParseException(new Object[]{e});
        }
    }

    private void removeSpaces(ParseReader str) throws IOException {
        while (!str.isClosed()) {
            char c = str.character();
            if (c != ' ' && c != '\n' && c != '\n' && c != '\r') {
                return;
            }
            str.consume();
        }
        return;
    }

    public void add(ParsingPart pp) {
        this.parts.add(pp);
    }
}

