/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.sql;

import de.mhus.lib.MCast;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.logging.MLog;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Properties;

public class MySqlDatabaseExport {
    public static boolean dumpDB(IConfig props, PrintWriter writer) {
        Properties prop = new Properties();
        for (String key : props.getConfigKeys()) {
            prop.setProperty(key, props.getExtracted(key));
        }
        return MySqlDatabaseExport.dumpDB(prop, writer);
    }

    public static boolean dumpDB(Properties props, PrintWriter writer) {
        String driverClassName = props.getProperty("driver.class");
        String driverURL = props.getProperty("driver.url");
        Connection dbConn = null;
        try {
            Class.forName(driverClassName);
            dbConn = DriverManager.getConnection(driverURL, props);
        }
        catch (Exception e) {
            MLog.e("Unable to connect to database", e);
            return false;
        }
        boolean ret = MySqlDatabaseExport.dumpDB(dbConn, props, writer);
        try {
            dbConn.close();
        }
        catch (SQLException e) {
            MLog.e("Unable to close database", e);
        }
        return ret;
    }

    public static boolean dumpDB(Connection dbConn, Properties props, PrintWriter writer) {
        try {
            String catalog = props.getProperty("catalog");
            String schema = props.getProperty("schemaPattern");
            String tables = props.getProperty("tableName");
            String columnNameQuote = props.getProperty("columnName.quoteChar", "");
            boolean dropTables = props.getProperty("dropTables", "true").equals("true");
            DatabaseMetaData dbMetaData = dbConn.getMetaData();
            ResultSet rs = dbMetaData.getTables(catalog, schema, tables, null);
            if (!rs.next()) {
                MLog.e("Unable to find any tables matching: catalog=" + catalog + " schema=" + schema + " tables=" + tables);
                rs.close();
            } else {
                do {
                    String tableName = rs.getString("TABLE_NAME");
                    String tableType = rs.getString("TABLE_TYPE");
                    if (!"TABLE".equalsIgnoreCase(tableType)) continue;
                    writer.print("\n\n-- " + tableName);
                    if (dropTables) {
                        writer.print("\nDROP TABLE " + tableName + ";\n");
                    }
                    writer.print("\nCREATE TABLE " + tableName + " (\n");
                    ResultSet tableMetaData = dbMetaData.getColumns(null, null, tableName, "%");
                    boolean firstLine = true;
                    while (tableMetaData.next()) {
                        if (firstLine) {
                            firstLine = false;
                        } else {
                            writer.print(",\n");
                        }
                        String columnName = tableMetaData.getString("COLUMN_NAME");
                        String columnType = tableMetaData.getString("TYPE_NAME");
                        int columnSize = tableMetaData.getInt("COLUMN_SIZE");
                        String nullable = tableMetaData.getString("IS_NULLABLE");
                        String nullString = "NULL";
                        if ("NO".equalsIgnoreCase(nullable)) {
                            nullString = "NOT NULL";
                        }
                        boolean needSize = columnType.startsWith("VAR");
                        writer.print("    " + columnNameQuote + columnName + columnNameQuote + " " + columnType);
                        if (needSize) {
                            writer.print(" (" + columnSize + ")");
                        }
                        writer.print(" " + nullString);
                    }
                    tableMetaData.close();
                    try {
                        ResultSet primaryKeys = dbMetaData.getPrimaryKeys(catalog, schema, tableName);
                        String primaryKeyName = null;
                        StringBuffer primaryKeyColumns = new StringBuffer();
                        while (primaryKeys.next()) {
                            String thisKeyName = primaryKeys.getString("PK_NAME");
                            if (thisKeyName != null && primaryKeyName == null || thisKeyName == null && primaryKeyName != null || thisKeyName != null && !thisKeyName.equals(primaryKeyName) || primaryKeyName != null && !primaryKeyName.equals(thisKeyName)) {
                                if (primaryKeyColumns.length() > 0) {
                                    writer.print(",\n    PRIMARY KEY ");
                                    if (primaryKeyName != null && !primaryKeyName.equals("PRIMARY")) {
                                        writer.print(primaryKeyName);
                                    }
                                    writer.print("(" + primaryKeyColumns.toString() + ")");
                                }
                                primaryKeyColumns = new StringBuffer();
                                primaryKeyName = thisKeyName;
                            }
                            if (primaryKeyColumns.length() > 0) {
                                primaryKeyColumns.append(", ");
                            }
                            primaryKeyColumns.append(primaryKeys.getString("COLUMN_NAME"));
                        }
                        if (primaryKeyColumns.length() > 0) {
                            writer.print(",\n    PRIMARY KEY ");
                            if (primaryKeyName != null && !primaryKeyName.equals("PRIMARY")) {
                                writer.print(primaryKeyName);
                            }
                            writer.print(" (" + primaryKeyColumns.toString() + ")");
                        }
                    }
                    catch (SQLException e) {
                        MLog.e("Unable to get primary keys for table " + tableName + " because ", e);
                    }
                    writer.print("\n);\n");
                    MySqlDatabaseExport.dumpTable(dbConn, writer, tableName);
                } while (rs.next());
                rs.close();
            }
            return true;
        }
        catch (SQLException e) {
            MLog.e(e);
            return false;
        }
    }

    private static void dumpTable(Connection dbConn, PrintWriter result, String tableName) {
        try {
            PreparedStatement stmt = dbConn.prepareStatement("SELECT * FROM " + tableName);
            ResultSet rs = stmt.executeQuery();
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            result.print("\n\n-- Data for " + tableName + "\n");
            int rowCnt = 0;
            while (rs.next()) {
                int i;
                if (rowCnt % 50 != 0 && rowCnt != 0) {
                    result.print(",\n");
                } else {
                    if (rowCnt != 0) {
                        result.print(";\n");
                    }
                    result.print("INSERT INTO " + tableName + " (");
                    for (i = 0; i < columnCount; ++i) {
                        if (i > 0) {
                            result.print(", ");
                        }
                        result.print(metaData.getColumnName(i + 1));
                    }
                    result.print(") VALUES ");
                }
                ++rowCnt;
                result.print(" (");
                for (i = 0; i < columnCount; ++i) {
                    Object value;
                    if (i > 0) {
                        result.print(", ");
                    }
                    if ((value = rs.getObject(i + 1)) == null) {
                        result.print("NULL");
                        continue;
                    }
                    if (value instanceof byte[]) {
                        byte[] bytes = (byte[])value;
                        result.print("X'");
                        try {
                            for (byte b : bytes) {
                                result.print(MCast.toHex2String(b));
                            }
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                        result.print("'");
                        continue;
                    }
                    String outputValue = value.toString();
                    if (outputValue.indexOf(92) > -1) {
                        outputValue = outputValue.replaceAll("\\\\", "\\\\\\\\");
                    }
                    if (outputValue.indexOf(39) > -1) {
                        outputValue = outputValue.replaceAll("'", "\\\\'");
                    }
                    if (outputValue.indexOf(34) > -1) {
                        outputValue = outputValue.replaceAll("\"", "\\\\\"");
                    }
                    result.print("'" + outputValue + "'");
                }
                result.print(")");
            }
            if (rowCnt != 0) {
                result.print(";\n");
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            MLog.e("Unable to dump table " + tableName + " because", e);
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("usage: db2sql <property file>");
        }
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(args[0]));
            PrintWriter pw = new PrintWriter(System.out);
            MySqlDatabaseExport.dumpDB(props, pw);
            pw.flush();
        }
        catch (IOException e) {
            System.err.println("Unable to open property file: " + args[0] + " exception: " + e);
        }
    }
}

