/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.sql;

import de.mhus.lib.MCast;
import de.mhus.lib.MDate;
import de.mhus.lib.sql.DbResult;
import java.io.InputStream;
import java.sql.Date;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MutableResult
extends DbResult {
    private LinkedList<Map<String, Object>> list = new LinkedList();
    private Map<String, Object> current = null;
    private LinkedList<String> columnList = new LinkedList();
    private List<String> roColumnNames = Collections.unmodifiableList(this.columnList);
    private Iterator<Map<String, Object>> iterator;

    public void add(Map<String, Object> row) {
        this.list.add(row);
    }

    public void reset() {
        this.iterator = this.list.iterator();
    }

    public void addColumnName(String name) {
        this.columnList.add(name);
    }

    @Override
    public void close() throws Exception {
        this.list = null;
    }

    @Override
    public String getString(String columnLabel) throws Exception {
        return String.valueOf(this.current.get(columnLabel));
    }

    @Override
    public boolean next() throws Exception {
        boolean has = this.iterator.hasNext();
        if (!has) {
            return false;
        }
        this.current = this.iterator.next();
        return true;
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws Exception {
        return (InputStream)this.current.get(columnLabel);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws Exception {
        return MCast.toboolean(this.getString(columnLabel), false);
    }

    @Override
    public int getInt(String columnLabel) throws Exception {
        return MCast.toint(this.getString(columnLabel), 0);
    }

    @Override
    public long getLong(String columnLabel) throws Exception {
        return MCast.tolong(this.getString(columnLabel), 0L);
    }

    @Override
    public float getFloat(String columnLabel) throws Exception {
        return MCast.tofloat(this.getString(columnLabel), 0.0f);
    }

    @Override
    public double getDouble(String columnLabel) throws Exception {
        return MCast.todouble(this.getString(columnLabel), 0.0);
    }

    @Override
    public Date getDate(String columnLabel) throws Exception {
        return this.getMDate(columnLabel).toSqlDate();
    }

    @Override
    public MDate getMDate(String columnLabel) throws Exception {
        return new MDate(this.getString(columnLabel));
    }

    @Override
    public List<String> getColumnNames() throws Exception {
        return this.roColumnNames;
    }
}

