/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.sql;

import de.mhus.lib.MException;
import de.mhus.lib.logging.Log;
import de.mhus.lib.parser.CompiledString;
import de.mhus.lib.sql.DbConnection;
import de.mhus.lib.sql.DbPrepared;
import de.mhus.lib.sql.DbResult;
import de.mhus.lib.sql.DbStatement;
import de.mhus.lib.sql.JdbcConnection;
import de.mhus.lib.sql.JdbcResult;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;

public class JdbcStatement
extends DbStatement {
    private static Log log = Log.getLog(JdbcStatement.class);
    private JdbcConnection dbCon;
    private Statement sth;
    private CompiledString query;
    private PreparedStatement preparedSth;
    private String xquery;

    JdbcStatement(JdbcConnection dbCon, DbPrepared prepared) {
        this.dbCon = dbCon;
        this.query = prepared.getQuery();
    }

    JdbcStatement(JdbcConnection dbCon, String query, String language) throws MException {
        this.dbCon = dbCon;
        this.query = dbCon.createQueryCompiler(language).compileString(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateSth() throws Exception {
        JdbcStatement jdbcStatement = this;
        synchronized (jdbcStatement) {
            if (this.sth == null || this.sth.isClosed()) {
                Connection con = this.dbCon.getConnection();
                this.sth = con.createStatement();
            }
        }
    }

    protected PreparedStatement prepareStatement(Map<String, Object> attributes, Statement sth, String query) throws SQLException {
        if (this.xquery != null & this.preparedSth != null && this.xquery.equals(query)) {
            return this.preparedSth;
        }
        this.closePreparedSth();
        if (attributes != null && attributes.containsKey("return_binary_attribute_0")) {
            PreparedStatement psth = this.dbCon.getConnection().prepareStatement(query);
            this.xquery = query;
            int nr = 0;
            while (attributes.containsKey("return_binary_attribute_" + nr)) {
                psth.setBinaryStream(nr + 1, (InputStream)attributes.get("return_binary_attribute_" + nr));
                attributes.remove("return_binary_attribute_" + nr);
                ++nr;
            }
            return psth;
        }
        return null;
    }

    protected void closePreparedSth() {
        if (this.preparedSth != null) {
            this.xquery = null;
            try {
                this.preparedSth.close();
            }
            catch (SQLException e) {
                log.t(e);
            }
            this.preparedSth = null;
        }
    }

    @Override
    public boolean execute(Map<String, Object> attributes) throws Exception {
        this.validateSth();
        String query = this.query.execute(attributes);
        log.t(query);
        try {
            this.preparedSth = this.prepareStatement(attributes, this.sth, query);
            return this.preparedSth == null ? this.sth.execute(query) : this.preparedSth.execute();
        }
        catch (Exception e) {
            log.e(query);
            throw e;
        }
    }

    @Override
    public DbResult getResultSet() throws SQLException {
        return new JdbcResult(this, this.sth.getResultSet());
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.sth.getUpdateCount();
    }

    @Override
    public DbResult executeQuery(Map<String, Object> attributes) throws Exception {
        this.validateSth();
        String query = this.query.execute(attributes);
        log.t(query);
        this.preparedSth = this.prepareStatement(attributes, this.sth, query);
        return new JdbcResult(this, this.preparedSth == null ? this.sth.executeQuery(query) : this.preparedSth.executeQuery());
    }

    @Override
    public int executeUpdate(Map<String, Object> attributes) throws Exception {
        this.validateSth();
        String query = this.query.execute(attributes);
        log.t(query);
        this.preparedSth = this.prepareStatement(attributes, this.sth, query);
        return this.preparedSth == null ? this.sth.executeUpdate(query) : this.preparedSth.executeUpdate();
    }

    @Override
    public DbConnection getConnection() {
        return this.dbCon;
    }

    @Override
    public void close() {
        this.closePreparedSth();
        if (this.sth == null) {
            return;
        }
        try {
            if (this.sth != null && !this.sth.isClosed()) {
                this.sth.close();
            }
        }
        catch (Exception e) {
            log.i(e);
        }
        this.sth = null;
    }
}

