/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.sql;

import de.mhus.lib.MPassword;
import de.mhus.lib.MString;
import de.mhus.lib.MTimeInterval;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.sql.DbProvider;
import de.mhus.lib.sql.Dialect;
import de.mhus.lib.sql.DialectDefault;
import de.mhus.lib.sql.DialectHsqldb;
import de.mhus.lib.sql.DialectMysql;
import de.mhus.lib.sql.InternalDbConnection;
import de.mhus.lib.sql.JdbcConnection;
import java.sql.Connection;
import java.sql.DriverManager;

public class JdbcProvider
extends DbProvider {
    private Dialect dialect;

    @Override
    public synchronized Dialect getDialect() {
        if (this.dialect == null) {
            String driver;
            IConfig concon = this.config.getConfig("connection");
            String dialectName = concon.getExtracted("dialect");
            if (this.dialect != null) {
                try {
                    this.dialect = (Dialect)this.activator.getObject(dialectName);
                }
                catch (Exception e) {
                    this.log().t(this.dialect, e);
                }
            }
            if (this.dialect == null && (driver = concon.getExtracted("driver")) != null) {
                if (driver.indexOf("hsqldb") > 0) {
                    this.dialect = new DialectHsqldb();
                } else if (driver.indexOf("mysql") > 0) {
                    this.dialect = new DialectMysql();
                }
            }
            if (this.dialect == null) {
                this.dialect = new DialectDefault();
            }
            this.log().t("dialect", this.dialect.getClass().getCanonicalName());
        }
        return this.dialect;
    }

    @Override
    public InternalDbConnection createConnection() throws Exception {
        IConfig concon = this.config.getConfig("connection");
        String driver = concon.getExtracted("driver");
        String url = concon.getExtracted("url");
        String user = concon.getExtracted("user");
        String pass = concon.getExtracted("pass");
        if (!MString.isEmpty(driver)) {
            Class.forName(driver);
        }
        this.log().t(driver, url, user);
        Connection con = DriverManager.getConnection(url, user, MPassword.decode(pass));
        con.setAutoCommit(false);
        JdbcConnection dbCon = new JdbcConnection(this, con);
        long timeoutUnused = MTimeInterval.toMilliseconds(this.config.getExtracted("timeout_unused"), 0);
        long timeoutLifetime = MTimeInterval.toMilliseconds(this.config.getExtracted("timeout_lifetime"), 0);
        if (timeoutUnused > 0L) {
            dbCon.setTimeoutUnused(timeoutUnused);
        }
        if (timeoutLifetime > 0L) {
            dbCon.setTimeoutLifetime(timeoutLifetime);
        }
        return dbCon;
    }
}

