/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.sql;

import de.mhus.lib.MException;
import de.mhus.lib.MSingleton;
import de.mhus.lib.parser.Parser;
import de.mhus.lib.parser.SimpleQueryCompiler;
import de.mhus.lib.sql.DbConnection;
import de.mhus.lib.sql.DbPrepared;
import de.mhus.lib.sql.DbProvider;
import de.mhus.lib.sql.DbStatement;
import de.mhus.lib.sql.InternalDbConnection;
import de.mhus.lib.sql.JdbcStatement;
import java.io.IOException;
import java.sql.Connection;

public class JdbcConnection
extends InternalDbConnection {
    public static final String LANGUAGE_SQL = "sql";
    private boolean used = false;
    private Connection connection;
    private DbProvider provider;
    private boolean closed;
    private long id;
    private StackTraceElement[] createStackTrace;

    @Override
    public void commit() throws Exception {
        this.log().t(this.poolId, this.id, "commit");
        if (this.closed) {
            throw new MException(this.poolId, this.id, "Connection not valid");
        }
        this.connection.commit();
    }

    @Override
    public boolean isReadOnly() throws Exception {
        if (this.closed) {
            throw new MException(this.poolId, this.id, "Connection not valid");
        }
        return this.connection.isReadOnly();
    }

    @Override
    public void rollback() throws Exception {
        this.log().t(this.poolId, this.id, "rollback");
        if (this.closed) {
            throw new IOException("Connection not valid");
        }
        this.connection.rollback();
    }

    public JdbcConnection(DbProvider provider, Connection con) {
        this.provider = provider;
        this.connection = con;
        this.id = MSingleton.instance().nextUniqueId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbStatement getStatement(String name) throws MException {
        JdbcConnection jdbcConnection = this;
        synchronized (jdbcConnection) {
            if (this.closed) {
                throw new MException(new Object[]{"Connection not valid"});
            }
            String[] query = this.provider.getQuery(name);
            if (query == null) {
                return null;
            }
            return new JdbcStatement(this, query[1], query[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbStatement createStatement(String sql, String language) throws MException {
        JdbcConnection jdbcConnection = this;
        synchronized (jdbcConnection) {
            if (this.closed) {
                throw new MException(new Object[]{"Connection not valid"});
            }
            return new JdbcStatement(this, sql, language);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        JdbcConnection jdbcConnection = this;
        synchronized (jdbcConnection) {
            return this.closed;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUsed() {
        JdbcConnection jdbcConnection = this;
        synchronized (jdbcConnection) {
            return this.used;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUsed(boolean used) {
        this.log().t(this.poolId, this.id, "used", used);
        super.setUsed(used);
        JdbcConnection jdbcConnection = this;
        synchronized (jdbcConnection) {
            this.used = used;
            if (!used) {
                try {
                    this.rollback();
                }
                catch (Exception e) {
                    this.log().d(e);
                    this.close();
                }
            }
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.log().t(this.poolId, this.id, "close");
        JdbcConnection jdbcConnection = this;
        synchronized (jdbcConnection) {
            try {
                if (this.connection != null && !this.connection.isClosed()) {
                    this.connection.close();
                    this.connection = null;
                }
            }
            catch (Throwable e) {
                this.log().d(this, e);
                this.connection = null;
            }
            this.closed = true;
        }
    }

    @Override
    public long getInstanceId() {
        return this.id;
    }

    @Override
    public Parser createQueryCompiler(String language) throws MException {
        if (this.pool != null) {
            return this.pool.getDialect().getQueryParser(language);
        }
        return new SimpleQueryCompiler();
    }

    @Override
    public DbConnection instance() {
        return this;
    }

    @Override
    public DbStatement createStatement(DbPrepared dbPrepared) {
        return new JdbcStatement(this, dbPrepared);
    }

    @Override
    public void setUsedTrace(StackTraceElement[] createStackTrace) {
        this.createStackTrace = createStackTrace;
    }

    @Override
    public StackTraceElement[] getUsedTrace() {
        return this.createStackTrace;
    }

    public void setTimeoutUnused(long timeoutUnused) {
        this.timeoutUnused = timeoutUnused;
    }

    public void setTimeoutLifetime(long timeoutLifetime) {
        this.timeoutLifetime = timeoutLifetime;
    }

    @Override
    public String getDefaultLanguage() {
        return LANGUAGE_SQL;
    }

    @Override
    public String[] getLanguages() {
        return new String[]{LANGUAGE_SQL};
    }

    @Override
    public DbStatement createStatement(String sql) throws MException {
        return this.createStatement(sql, this.provider.getDialect().detectLanguage(sql));
    }
}

