/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.sql;

import de.mhus.lib.lang.MObject;
import de.mhus.lib.sql.DbConnection;
import de.mhus.lib.sql.DbPool;

public abstract class InternalDbConnection
extends MObject
implements DbConnection {
    protected DbPool pool;
    protected String poolId;
    protected long creationTime = System.currentTimeMillis();
    protected long lastUsedTime = 0L;
    protected long timeoutUnused = 600000L;
    protected long timeoutLifetime = 3600000L;

    public void setPool(DbPool pool) {
        this.poolId = pool.getPoolId();
        this.pool = pool;
    }

    public boolean checkTimedOut() {
        if (this.isUsed()) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.creationTime > this.timeoutLifetime || this.lastUsedTime != 0L && currentTime - this.lastUsedTime > this.timeoutUnused) {
            this.log().t("timeout");
            this.close();
            return true;
        }
        return false;
    }

    @Override
    public void setUsed(boolean used) {
        this.lastUsedTime = System.currentTimeMillis();
    }
}

