/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.sql;

import de.mhus.lib.MDate;
import de.mhus.lib.MSql;
import de.mhus.lib.sql.Dialect;
import de.mhus.lib.sql.DialectDefault;
import java.text.SimpleDateFormat;

public class DialectMysql
extends DialectDefault {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public String normalizeColumnName(String columnName) {
        return columnName + "_";
    }

    @Override
    public String getDbType(String type, String size) {
        String t = type.toUpperCase();
        if (t.equals(Dialect.TYPE.FLOAT.name())) {
            t = "DOUBLE";
        } else if (t.equals(Dialect.TYPE.BLOB.name())) {
            t = "LONGBLOB";
        } else {
            return super.getDbType(t, size);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toSqlDateValue(MDate date) {
        SimpleDateFormat simpleDateFormat = dateFormat;
        synchronized (simpleDateFormat) {
            return "'" + dateFormat.format(date.toDate()) + "'";
        }
    }

    @Override
    public String escape(String text) {
        String ret = MSql.escape(text);
        if (ret == null || text == null) {
            return ret;
        }
        if (ret.indexOf(92) < 0) {
            return ret;
        }
        return ret.replaceAll("\\\\", "\\\\\\\\");
    }
}

