/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.sql;

import de.mhus.lib.MDate;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.sql.DialectDefault;
import java.sql.Statement;
import java.text.SimpleDateFormat;

public class DialectHsqldb
extends DialectDefault {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    protected String getFieldConfig(IConfig f) {
        boolean notNull;
        String type = this.getDbType(f);
        String ret = f.getString("name", null).toUpperCase() + " " + type;
        String def = f.getExtracted("default");
        if (def != null) {
            def = this.getDbDef(def);
            ret = ret + " DEFAULT " + def;
        }
        ret = (notNull = f.getBoolean("notnull", false)) ? ret + " NOT NULL" : ret + " NULL";
        return ret;
    }

    protected String getFieldConfigWithoutExtras(IConfig f) {
        String type = this.getDbType(f);
        String ret = f.getString("name", null).toUpperCase() + " " + type;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toSqlDateValue(MDate date) {
        SimpleDateFormat simpleDateFormat = dateFormat;
        synchronized (simpleDateFormat) {
            return "TO_DATE('" + dateFormat.format(date.toDate()) + "','YYYY-MM-DD HH:MI:SS')";
        }
    }

    @Override
    public String normalizeColumnName(String columnName) {
        return columnName.toUpperCase();
    }

    @Override
    protected void alterColumn(Statement sth, String tn, IConfig cfield) {
        String sql = "ALTER TABLE " + tn + " ALTER COLUMN " + this.getFieldConfigWithoutExtras(cfield);
        log.t("alter table", sql);
        try {
            sth.execute(sql);
        }
        catch (Exception e) {
            log.i(sql, e);
        }
    }

    @Override
    protected void alterTableChangePrimaryKey(Statement sth, String tn, String keys) {
        this.alterTableDropPrimaryKey(sth, tn);
        this.alterTableAddPrimaryKey(sth, tn, keys);
    }

    @Override
    protected void recreateIndex(Statement sth, boolean unique, boolean btree, String iName, String table, String columns) {
        iName = table + iName;
        String sql = "DROP INDEX " + iName;
        log.t(sql);
        try {
            sth.execute(sql.toString());
        }
        catch (Exception e) {
            log.i(sql, e);
        }
        sql = "CREATE " + (unique ? "UNIQUE" : "") + " INDEX " + iName + (btree ? " USING BTREE" : "") + " ON " + table + "(" + columns + ")";
        log.t(sql);
        try {
            sth.execute(sql.toString());
        }
        catch (Exception e) {
            log.i(sql, e);
        }
    }

    @Override
    protected void createIndex(Statement sth, boolean unique, boolean btree, String iName, String table, String columns) {
        iName = table + iName;
        String sql = "CREATE " + (unique ? "UNIQUE" : "") + " INDEX " + iName + (btree ? " USING BTREE" : "") + " ON " + table + "(" + columns + ")";
        log.t(sql);
        try {
            sth.execute(sql.toString());
        }
        catch (Exception e) {
            log.i(sql, e);
        }
    }

    @Override
    protected boolean equalsIndexName(String table, String iName, String iName2) {
        return iName2.equals(table + iName);
    }

    @Override
    public String normalizeTableName(String tableName) throws Exception {
        return tableName.toUpperCase() + "_";
    }

    @Override
    public String normalizeIndexName(String tableName) throws Exception {
        return tableName.toUpperCase();
    }
}

