/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.sql;

import de.mhus.lib.MSql;
import de.mhus.lib.MString;
import de.mhus.lib.cao.CaoMetaDefinition;
import de.mhus.lib.cao.util.MetadataBundle;
import de.mhus.lib.cao.util.MutableMetadata;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.sql.DbConnection;
import de.mhus.lib.sql.Dialect;
import de.mhus.lib.sql.JdbcConnection;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.TreeSet;

public class DialectDefault
extends Dialect {
    @Override
    public void createTables(IConfig data, DbConnection db, MetadataBundle caoBundle) throws Exception {
        Connection con = ((JdbcConnection)db.instance()).getConnection();
        Statement sth = con.createStatement();
        DatabaseMetaData meta = con.getMetaData();
        for (IConfig ctable : data.getConfigBundle("table")) {
            MutableMetadata caoMeta;
            String tName = ctable.getExtracted("name");
            String tPrefix = ctable.getExtracted("prefix", "");
            String tnOrg = tPrefix + tName;
            log.t("table", tnOrg);
            String tn = this.normalizeTableName(tnOrg);
            ResultSet tRes = meta.getTables(null, null, tn, new String[]{"TABLE"});
            if (caoBundle != null) {
                caoBundle.getBundle().remove(tName);
            }
            if (tRes.next()) {
                log.t("--- found table", tName);
                caoMeta = null;
                if (caoBundle != null) {
                    caoMeta = new MutableMetadata(caoBundle.getDriver());
                    caoBundle.getBundle().put(tName, caoMeta);
                }
                for (IConfig cfield : ctable.getConfigBundle("field")) {
                    String fNameOrg = cfield.getExtracted("name");
                    String fName = this.normalizeColumnName(fNameOrg);
                    if (cfield.getString("category", "").indexOf("[virtual]") < 0) {
                        ResultSet fRes = meta.getColumns(null, null, tn, fName);
                        log.t("field", tName, fNameOrg);
                        if (fRes.next()) {
                            String fName2 = fRes.getString("COLUMN_NAME");
                            String fType = fRes.getString("TYPE_NAME");
                            int fSize = fRes.getInt("COLUMN_SIZE");
                            int fNull = fRes.getInt("NULLABLE");
                            String fDef = fRes.getString("COLUMN_DEF");
                            log.t("found field", tName, fName2, fType, fSize, fNull, fDef);
                            String fType1 = this.getDbType(cfield);
                            if (fType.indexOf("CHAR") >= 0) {
                                fType = fType + "(" + fSize + ")";
                            }
                            if (!fType1.equals(fType)) {
                                this.alterColumn(sth, tn, cfield);
                            } else {
                                boolean xdef;
                                boolean bl = xdef = cfield.getProperty("default") != null;
                                if (fDef != null && !xdef) {
                                    this.alterColumnDropDefault(sth, tn, fName);
                                } else if (fDef == null && xdef || fDef != null && !fDef.equals(cfield.getProperty("default"))) {
                                    this.alterColumnSetDefault(sth, tn, fName, cfield);
                                }
                            }
                        } else {
                            this.alterColumnAdd(sth, tn, cfield);
                        }
                        fRes.close();
                    }
                    if (caoMeta == null) continue;
                    List<CaoMetaDefinition> metaMap = caoMeta.getMap();
                    CaoMetaDefinition.TYPE caoType = this.getCaoType(cfield);
                    String[] categories = MString.splitIgnoreEmpty(cfield.getString("category", ""), ",", true);
                    metaMap.add(new CaoMetaDefinition(caoMeta, cfield.getExtracted("name"), caoType, cfield.getExtracted("nls"), cfield.getInt("size", 100), categories));
                }
                if (tRes.next()) {
                    log.t("*** found more then one tables", tName);
                }
            } else {
                log.t("--- table not found", tName);
                caoMeta = null;
                if (caoBundle != null) {
                    caoMeta = new MutableMetadata(caoBundle.getDriver());
                    caoBundle.getBundle().put(tName, caoMeta);
                }
                this.createTable(sth, tn, ctable);
                for (IConfig f : ctable.getConfigBundle("field")) {
                    if (caoMeta == null) continue;
                    List<CaoMetaDefinition> metaMap = caoMeta.getMap();
                    CaoMetaDefinition.TYPE caoType = this.getCaoType(f);
                    metaMap.add(new CaoMetaDefinition(caoMeta, f.getExtracted("name"), caoType, f.getExtracted("nls"), f.getInt("size", 100), new String[0]));
                }
            }
            tRes.close();
            String keys = ctable.getExtracted("primary_key");
            if (keys != null) {
                TreeSet<String> set = new TreeSet<String>();
                for (String item : keys.split(",")) {
                    set.add(this.normalizeColumnName(item));
                }
                keys = MString.join(set.iterator(), ",");
            }
            tRes = meta.getPrimaryKeys(null, null, tn);
            String keys2 = null;
            while (tRes.next()) {
                if (keys2 == null) {
                    keys2 = tRes.getString("COLUMN_NAME");
                    continue;
                }
                keys2 = keys2 + "," + tRes.getString("COLUMN_NAME");
            }
            tRes.close();
            if (keys2 != null) {
                log.t("found primary key", keys2);
                if (keys == null) {
                    this.alterTableDropPrimaryKey(sth, tn);
                    continue;
                }
                if (keys.equals(keys2)) continue;
                this.alterTableChangePrimaryKey(sth, tn, keys);
                continue;
            }
            if (keys == null) continue;
            this.alterTableAddPrimaryKey(sth, tn, keys);
        }
        sth.close();
    }

    protected void createTable(Statement sth, String tn, IConfig ctable) {
        StringBuffer sql = new StringBuffer();
        sql.append("create table " + tn + " ( ");
        boolean first = true;
        for (IConfig f : ctable.getConfigBundle("field")) {
            if (!first) {
                sql.append(",");
            }
            sql.append(this.getFieldConfig(f));
            first = false;
        }
        sql.append(" )");
        log.t(sql);
        try {
            sth.execute(sql.toString());
        }
        catch (Exception e) {
            log.i(sql, e);
        }
    }

    protected void alterTableAddPrimaryKey(Statement sth, String tn, String keys) {
        String sql = "ALTER TABLE " + tn + " ADD PRIMARY KEY(" + keys + ")";
        log.t("new primary key", sql);
        try {
            sth.execute(sql.toString());
        }
        catch (Exception e) {
            log.i(sql, e);
        }
    }

    protected void alterTableChangePrimaryKey(Statement sth, String tn, String keys) {
        String sql = "ALTER TABLE " + tn + " DROP PRIMARY KEY, ADD PRIMARY KEY(" + keys + ")";
        log.t("new primary key", sql);
        try {
            sth.execute(sql.toString());
        }
        catch (Exception e) {
            log.i(sql, e);
        }
    }

    protected void alterTableDropPrimaryKey(Statement sth, String tn) {
        String sql = "ALTER TABLE " + tn + " DROP PRIMARY KEY";
        log.t("drop primary key", sql);
        try {
            sth.execute(sql.toString());
        }
        catch (Exception e) {
            log.i(sql, e);
        }
    }

    protected void alterColumnAdd(Statement sth, String tn, IConfig cfield) {
        String sql = "ALTER TABLE " + tn + " ADD COLUMN " + this.getFieldConfig(cfield);
        log.t("alter table", sql);
        try {
            sth.execute(sql);
        }
        catch (Exception e) {
            log.i(sql, e);
        }
    }

    protected void alterColumnSetDefault(Statement sth, String tn, String fName, IConfig cfield) {
        String sql = "ALTER TABLE " + tn + " ALTER COLUMN " + fName + " SET DEFAULT " + this.getDbDef(cfield.getString("default", null));
        log.t("alter table", sql);
        try {
            sth.execute(sql);
        }
        catch (Exception e) {
            log.i(sql, e);
        }
    }

    protected void alterColumnDropDefault(Statement sth, String tn, String fName) {
        String sql = "ALTER TABLE " + tn + " ALTER COLUMN " + fName + " DROP DEFAULT";
        log.t("alter table", sql);
        try {
            sth.execute(sql);
        }
        catch (Exception e) {
            log.i(sql, e);
        }
    }

    protected void alterColumn(Statement sth, String tn, IConfig cfield) {
        String sql = "ALTER TABLE " + tn + " MODIFY COLUMN " + this.getFieldConfig(cfield);
        log.t("alter table", sql);
        try {
            sth.execute(sql);
        }
        catch (Exception e) {
            log.i(sql, e);
        }
    }

    @Override
    public void createIndexes(IConfig data, DbConnection db, MetadataBundle caoMeta) throws Exception {
        Connection con = ((JdbcConnection)db.instance()).getConnection();
        Statement sth = con.createStatement();
        DatabaseMetaData meta = con.getMetaData();
        for (IConfig cindex : data.getConfigBundle("index")) {
            String iNameOrg = cindex.getExtracted("name");
            String iName = this.normalizeIndexName(iNameOrg);
            String tableName = cindex.getExtracted("table");
            String prefix = cindex.getExtracted("prefix", "");
            String tableOrg = prefix + tableName;
            String table = this.normalizeTableName(tableOrg);
            boolean btree = cindex.getBoolean("btree", false);
            String columnsOrg = cindex.getExtracted("fields");
            String columns = null;
            if (columnsOrg != null) {
                TreeSet<String> set = new TreeSet<String>();
                for (String item : columnsOrg.split(",")) {
                    set.add(this.normalizeColumnName(item.trim()));
                }
                columns = MString.join(set.iterator(), ",");
            } else {
                columns = "";
            }
            boolean unique = cindex.getBoolean("unique", false);
            ResultSet res = meta.getIndexInfo(null, null, table, unique, false);
            String columns2 = null;
            while (res.next()) {
                String iName2 = res.getString("INDEX_NAME");
                String fName2 = res.getString("COLUMN_NAME");
                if (iName2 == null || fName2 == null || !this.equalsIndexName(table, iName, iName2)) continue;
                if (columns2 == null) {
                    columns2 = fName2;
                    continue;
                }
                columns2 = columns2 + "," + fName2;
            }
            res.close();
            if (columns2 == null) {
                log.t("create index", iNameOrg, columnsOrg);
                this.createIndex(sth, unique, btree, iName, table, columns);
                continue;
            }
            if (columns.equals(columns2)) continue;
            log.t("recreate index", iName, columns2, columns);
            this.recreateIndex(sth, unique, btree, iName, table, columns);
        }
        sth.close();
    }

    protected boolean equalsIndexName(String table, String iName, String iName2) {
        return iName2.equals(iName);
    }

    protected void recreateIndex(Statement sth, boolean unique, boolean btree, String iName, String table, String columns) {
        String sql = "DROP INDEX " + iName + " ON " + table;
        log.t(sql);
        try {
            sth.execute(sql.toString());
        }
        catch (Exception e) {
            log.i(sql, e);
        }
        sql = "CREATE " + (unique ? "UNIQUE" : "") + " INDEX " + iName + (btree ? " USING BTREE" : "") + " ON " + table + "(" + columns + ")";
        log.t(sql);
        try {
            sth.execute(sql.toString());
        }
        catch (Exception e) {
            log.i(sql, e);
        }
    }

    protected void createIndex(Statement sth, boolean unique, boolean btree, String iName, String table, String columns) {
        String sql = "CREATE " + (unique ? "UNIQUE" : "") + " INDEX " + iName + (btree ? " USING BTREE" : "") + " ON " + table + "(" + columns + ")";
        log.t(sql);
        try {
            sth.execute(sql.toString());
        }
        catch (Exception e) {
            log.i(sql, e);
        }
    }

    @Override
    public void createData(IConfig data, DbConnection db) throws Exception {
        Connection con = ((JdbcConnection)db.instance()).getConnection();
        Statement sth = con.createStatement();
        for (IConfig cdata : data.getConfigBundle("data")) {
            String select = cdata.getExtracted("select");
            String set = cdata.getExtracted("set");
            String column = cdata.getExtracted("column");
            String condition = cdata.getExtracted("condition");
            boolean foundRow = false;
            boolean foundError = false;
            if (select != null) {
                log.t("select", select);
                try {
                    ResultSet res = sth.executeQuery(select);
                    if (res.next()) {
                        if (set != null && column != null) {
                            data.setProperty(set, column);
                        }
                        foundRow = true;
                    }
                    res.close();
                }
                catch (Exception e) {
                    log.i(select, e);
                    foundError = true;
                }
            }
            boolean accepted = true;
            if (condition != null) {
                boolean bl = accepted = condition.equals("found") && foundRow || condition.equals("not found") && !foundRow || condition.equals("error") && foundError || condition.equals("no error") && !foundError;
            }
            if (!accepted) continue;
            for (IConfig cexecute : cdata.getConfigBundle("execute")) {
                String sql = cexecute.getExtracted("sql");
                if (sql == null) continue;
                log.t("execute", sql);
                try {
                    sth.execute(sql.toString());
                }
                catch (Exception e) {
                    log.i(sql, e);
                }
            }
        }
        sth.close();
    }

    @Override
    public String normalizeTableName(String tableName) throws Exception {
        return tableName + "_";
    }

    @Override
    public String normalizeIndexName(String tableName) throws Exception {
        return tableName;
    }

    @Override
    public String normalizeColumnName(String columnName) {
        return columnName;
    }

    @Override
    public String escape(String text) {
        return MSql.escape(text);
    }
}

