/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.sql;

import de.mhus.lib.MCast;
import de.mhus.lib.MDate;
import de.mhus.lib.MException;
import de.mhus.lib.MSql;
import de.mhus.lib.cao.CaoMetaDefinition;
import de.mhus.lib.cao.util.MetadataBundle;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.logging.Log;
import de.mhus.lib.parser.Parser;
import de.mhus.lib.parser.ParsingPart;
import de.mhus.lib.sql.DbConnection;
import de.mhus.lib.sql.commonparser.Common2SqlCompiler;
import de.mhus.lib.sql.parser.FunctionPart;
import de.mhus.lib.sql.parser.ICompiler;
import de.mhus.lib.sql.parser.SqlCompiler;

public abstract class Dialect
implements ICompiler {
    protected static final Log log = Log.getLog(Dialect.class);
    public static final String I_TYPE = "type";
    public static final String I_UNIQUE = "unique";
    public static final String I_NAME = "name";
    public static final String I_TABLE = "table";
    public static final String I_FIELDS = "fields";
    public static final String K_PRIMARY_KEY = "primary_key";
    public static final String K_NAME = "name";
    public static final String K_TYPE = "type";
    public static final String K_SIZE = "size";
    public static final String K_DEFAULT = "default";
    public static final String K_NOT_NULL = "notnull";
    public static final String K_CATEGORIES = "category";
    public static final String C_VIRTUAL = "[virtual]";
    public static final String C_PRIMARY_KEY = "[pk]";
    public static final String C_ENUMERATION = "[enum]";
    private Parser sqlParser = new SqlCompiler(this);
    private Parser commonParser = new Common2SqlCompiler(this);

    public static String typeEnumToString(TYPE type) {
        if (type == null) {
            return null;
        }
        if (type == TYPE.UNKNOWN) {
            return null;
        }
        return type.name().toLowerCase();
    }

    public void createStructure(IConfig data, DbConnection db, MetadataBundle caoMeta) throws Exception {
        this.createTables(data, db, caoMeta);
        this.createIndexes(data, db, caoMeta);
        this.createData(data, db);
    }

    public abstract void createTables(IConfig var1, DbConnection var2, MetadataBundle var3) throws Exception;

    public abstract void createIndexes(IConfig var1, DbConnection var2, MetadataBundle var3) throws Exception;

    public abstract void createData(IConfig var1, DbConnection var2) throws Exception;

    protected String getFieldConfig(IConfig f) {
        boolean notNull;
        String type = this.getDbType(f);
        String ret = this.normalizeColumnName(f.getString("name", null)) + " " + type;
        String def = f.getExtracted(K_DEFAULT);
        if (def != null) {
            def = this.getDbDef(def);
            ret = ret + " DEFAULT " + def;
        }
        ret = (notNull = f.getBoolean(K_NOT_NULL, false)) ? ret + " NOT NULL" : ret + " NULL";
        return ret;
    }

    protected String getDbDef(String def) {
        try {
            Double.valueOf(def);
        }
        catch (NumberFormatException e) {
            def = MSql.quoteSQL(def);
        }
        return def;
    }

    protected CaoMetaDefinition.TYPE getCaoType(IConfig f) {
        String type = f.getString("type", TYPE.STRING.name()).toUpperCase();
        CaoMetaDefinition.TYPE t = CaoMetaDefinition.TYPE.STRING;
        if (f.getString(K_CATEGORIES, "").indexOf(C_ENUMERATION) > -1) {
            t = CaoMetaDefinition.TYPE.STRING;
        } else if (!(type.equals(TYPE.STRING.name()) || type.equals("CHAR") || type.equals("VARCHAR"))) {
            if (type.equals(TYPE.INT.name()) || type.equals("INTEGER")) {
                t = CaoMetaDefinition.TYPE.LONG;
            } else if (type.equals("DATE")) {
                t = CaoMetaDefinition.TYPE.DATETIME;
            } else if (type.equals(TYPE.DATETIME.name())) {
                t = CaoMetaDefinition.TYPE.DATETIME;
            } else if (type.equals("TIME")) {
                t = CaoMetaDefinition.TYPE.DATETIME;
            } else if (type.equals("TIMESTAMP")) {
                t = CaoMetaDefinition.TYPE.DATETIME;
            } else if (type.equals(TYPE.BOOL.name()) || type.equals("BOOLEAN")) {
                t = CaoMetaDefinition.TYPE.BOOLEAN;
            } else if (type.equals(TYPE.BLOB.name())) {
                t = CaoMetaDefinition.TYPE.BINARY;
            } else if (type.equals(TYPE.DOUBLE.name())) {
                t = CaoMetaDefinition.TYPE.DOUBLE;
            } else if (type.equals(TYPE.FLOAT.name())) {
                t = CaoMetaDefinition.TYPE.DOUBLE;
            } else if (!type.equals("TEXT") && !type.equals("LONGTEXT")) {
                if (type.equals("LONGBLOB")) {
                    t = CaoMetaDefinition.TYPE.BINARY;
                } else if (type.equals(TYPE.UUID.name())) {
                    t = CaoMetaDefinition.TYPE.ELEMENT;
                }
            }
        }
        return t;
    }

    public String getDbType(IConfig f) {
        return this.getDbType(f.getString("type", "string"), f.getString(K_SIZE, "100"));
    }

    public String getDbType(String type, String size) {
        String t = type.toUpperCase();
        if (t.equals(TYPE.STRING.name()) || t.equals("CHAR") || t.equals("VARCHAR")) {
            t = "VARCHAR(" + size + ")";
        } else if (t.equals(TYPE.INT.name()) || t.equals("INTEGER")) {
            t = "INT";
        } else if (t.equals(TYPE.LONG.name())) {
            t = "BIGINT";
        } else if (t.equals("DATE")) {
            t = "DATE";
        } else if (t.equals(TYPE.DATETIME.name())) {
            t = "DATETIME";
        } else if (t.equals("TIME")) {
            t = "TIME";
        } else if (t.equals("TIMESTAMP")) {
            t = "TIMESTAMP";
        } else if (t.equals(TYPE.BOOL.name()) || t.equals("BOOLEAN")) {
            t = "TINYINT";
        } else if (t.equals(TYPE.BLOB.name())) {
            t = "BLOB";
        } else if (t.equals(TYPE.DOUBLE.name())) {
            t = "DOUBLE";
        } else if (t.equals(TYPE.FLOAT.name())) {
            t = "FLOAT";
        } else if (t.equals("TEXT")) {
            t = "TEXT";
        } else if (t.equals("LONGTEXT")) {
            t = "LONGTEXT";
        } else if (t.equals("LONGBLOB")) {
            t = "LONGBLOB";
        } else if (t.equals(TYPE.UUID.name())) {
            t = "VARCHAR(40)";
        }
        return t;
    }

    public abstract String normalizeIndexName(String var1) throws Exception;

    public abstract String normalizeTableName(String var1) throws Exception;

    public abstract String normalizeColumnName(String var1);

    public Parser getQueryParser(String language) throws MException {
        if (language == null || "sql".equals(language)) {
            return this.sqlParser;
        }
        if ("common".equals(language)) {
            return this.commonParser;
        }
        throw new MException(this, "language not supported", language);
    }

    @Override
    public boolean isParseAttributes() {
        return true;
    }

    @Override
    public ParsingPart compileFunction(FunctionPart function) {
        return function;
    }

    @Override
    public String toSqlDateValue(MDate date) {
        return "'" + date.toString() + "'";
    }

    @Override
    public String valueToString(Object value) {
        return MCast.objectToString(value);
    }

    public String detectLanguage(String sql) {
        if (sql == null) {
            return null;
        }
        if (sql.startsWith("<common>")) {
            return "common";
        }
        return null;
    }

    public static enum TYPE {
        INT,
        LONG,
        BOOL,
        DOUBLE,
        FLOAT,
        STRING,
        DATETIME,
        UUID,
        BLOB,
        UNKNOWN;

    }
}

