/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.sql;

import de.mhus.lib.MActivator;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.lang.MObject;
import de.mhus.lib.sql.Dialect;
import de.mhus.lib.sql.InternalDbConnection;

public abstract class DbProvider
extends MObject {
    protected IConfig config;
    protected MActivator activator;

    public abstract InternalDbConnection createConnection() throws Exception;

    public void init(IConfig config, MActivator activator) {
        this.config = config;
        this.activator = activator;
    }

    public String[] getQuery(String name) {
        IConfig query = this.config.getConfig("queries");
        String queryLanguage = null;
        String queryString = query.getString(name, null);
        String[] out = new String[]{queryLanguage, queryString};
        if (queryString == null) {
            for (IConfig q : query.getConfigBundle("query")) {
                if (!q.getString("name", "").equals(name)) continue;
                queryLanguage = q.getExtracted("language");
                queryString = q.getExtracted("string");
                out = new String[]{queryLanguage, queryString};
                break;
            }
        }
        return out;
    }

    public abstract Dialect getDialect();

    public String getName() {
        return this.config.getExtracted("name");
    }

    public MActivator getActivator() {
        return this.activator;
    }
}

