/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.sql;

import de.mhus.lib.MActivator;
import de.mhus.lib.MException;
import de.mhus.lib.MSingleton;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.sql.DbPool;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class DbPoolBundle {
    private IConfig config;
    private MActivator activator;
    private Map<String, DbPool> bundle = new HashMap<String, DbPool>();

    public DbPoolBundle() {
        this(null, null);
    }

    public DbPoolBundle(IConfig config, MActivator activator) {
        if (config == null) {
            config = MSingleton.instance().getConfig(DbPoolBundle.class, null);
        }
        if (activator == null) {
            activator = MSingleton.instance().getActivator();
        }
        this.config = config;
        this.activator = activator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbPool getPool(String name) throws Exception {
        if (this.bundle == null) {
            throw new MException(new Object[]{"Bundle already closed"});
        }
        Map<String, DbPool> map = this.bundle;
        synchronized (map) {
            DbPool pool = this.bundle.get(name);
            if (pool == null) {
                IConfig poolCon = this.config.getConfig(name);
                if (poolCon != null) {
                    pool = new DbPool(poolCon, this.activator);
                    this.bundle.put(name, pool);
                } else {
                    throw new MException("pool config not found", name);
                }
            }
            return pool;
        }
    }

    public String[] getNames() {
        LinkedList<String> out = new LinkedList<String>();
        for (IConfig c : this.config.getConfigBundle()) {
            out.add(c.getName());
        }
        return out.toArray(new String[out.size()]);
    }

    public IConfig getConfig(String name) {
        return this.config.getConfig(name);
    }

    public IConfig getConfig() {
        return this.config;
    }

    public void reset() {
        this.bundle = new HashMap<String, DbPool>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.bundle == null) {
            return;
        }
        Map<String, DbPool> map = this.bundle;
        synchronized (map) {
            for (DbPool pool : this.bundle.values()) {
                pool.close();
            }
            this.bundle = null;
        }
    }
}

