/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.sql;

import de.mhus.lib.MActivator;
import de.mhus.lib.MException;
import de.mhus.lib.MHousekeeperTask;
import de.mhus.lib.MSingleton;
import de.mhus.lib.config.HashConfig;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.jmx.JmxManaged;
import de.mhus.lib.jmx.MJmx;
import de.mhus.lib.sql.DbConnection;
import de.mhus.lib.sql.DbConnectionProxy;
import de.mhus.lib.sql.DbPrepared;
import de.mhus.lib.sql.DbProvider;
import de.mhus.lib.sql.Dialect;
import de.mhus.lib.sql.InternalDbConnection;
import de.mhus.lib.sql.JdbcProvider;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.List;

@JmxManaged(descrition="Database pool")
public class DbPool
extends MJmx {
    private List<InternalDbConnection> pool = new LinkedList<InternalDbConnection>();
    private DbProvider provider;
    private String name;
    private IConfig config = MSingleton.instance().getConfig(this, new HashConfig());

    public DbPool() throws Exception {
        this(null, null);
    }

    public DbPool(IConfig config, MActivator activator) throws Exception {
        this(DbPool.createProvider(config, activator));
    }

    protected static DbProvider createProvider(IConfig config, MActivator activator) throws Exception {
        if (config == null) {
            config = MSingleton.instance().getConfig().getConfig(DbPool.class.getName());
        }
        if (activator == null) {
            activator = MSingleton.instance().getActivator();
        }
        DbProvider provider = (DbProvider)activator.createObject(config.getExtracted("provider", JdbcProvider.class.getCanonicalName()));
        provider.init(config, activator);
        return provider;
    }

    public DbPool(DbProvider provider) {
        this.setProvider(provider);
        Housekeeper housekeeper = new Housekeeper(this);
        MSingleton.instance().getHousekeeper().register(housekeeper, this.config.getLong("housekeeper_sleep", 30000L), true);
    }

    protected void setProvider(DbProvider provider) {
        this.provider = provider;
        this.name = provider.getName();
        if (this.name == null) {
            this.name = "pool";
        }
        this.name = this.name + MSingleton.instance().nextUniqueId();
    }

    public DbProvider getProvider() {
        return this.provider;
    }

    public Dialect getDialect() {
        return this.provider.getDialect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public DbConnection getConnection() throws Exception {
        this.log().t(this.name, "getConnection");
        boolean foundClosed = false;
        try {
            List<InternalDbConnection> list = this.pool;
            // MONITORENTER : list
            for (InternalDbConnection con : this.pool) {
                if (con.isClosed() || con.checkTimedOut()) {
                    foundClosed = true;
                    continue;
                }
                if (con.isUsed()) continue;
                con.setUsed(true);
                DbConnectionProxy dbConnectionProxy = new DbConnectionProxy(con);
                // MONITOREXIT : list
                if (!foundClosed) return dbConnectionProxy;
                this.cleanup(false);
                return dbConnectionProxy;
            }
        }
        catch (Throwable throwable) {
            if (!foundClosed) throw throwable;
            this.cleanup(false);
            throw throwable;
        }
        InternalDbConnection con = this.provider.createConnection();
        con.setPool(this);
        this.pool.add(con);
        con.setUsed(true);
        DbConnectionProxy dbConnectionProxy = new DbConnectionProxy(con);
        // MONITOREXIT : list
        if (!foundClosed) return dbConnectionProxy;
        this.cleanup(false);
        return dbConnectionProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JmxManaged(descrition="Current size of the pool")
    public int getSize() {
        List<InternalDbConnection> list = this.pool;
        synchronized (list) {
            return this.pool.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JmxManaged(descrition="Current used connections in the pool")
    public int getUsedSize() {
        int cnt = 0;
        List<InternalDbConnection> list = this.pool;
        synchronized (list) {
            for (DbConnection dbConnection : new LinkedList<InternalDbConnection>(this.pool)) {
                if (!dbConnection.isUsed()) continue;
                ++cnt;
            }
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JmxManaged(descrition="Cleanup unused connections")
    public void cleanup(boolean unusedAlso) {
        this.log().t(this.name, "cleanup");
        List<InternalDbConnection> list = this.pool;
        synchronized (list) {
            for (InternalDbConnection con : new LinkedList<InternalDbConnection>(this.pool)) {
                try {
                    con.checkTimedOut();
                    if ((!unusedAlso || con.isUsed()) && !con.isClosed()) continue;
                    con.close();
                    this.pool.remove(con);
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.pool == null) {
            return;
        }
        this.log().t(this.name, "close");
        List<InternalDbConnection> list = this.pool;
        synchronized (list) {
            for (InternalDbConnection con : this.pool) {
                con.close();
            }
            this.pool = null;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public DbPrepared getStatement(String name) throws MException {
        String[] query = this.provider.getQuery(name);
        return new DbPrepared(this, query[1], query[0]);
    }

    public DbPrepared createStatement(String sql) throws MException {
        return this.createStatement(sql, null);
    }

    public DbPrepared createStatement(String sql, String language) throws MException {
        return new DbPrepared(this, sql, language);
    }

    @JmxManaged(descrition="Unique name of the pool")
    public String getPoolId() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JmxManaged(descrition="Return the usage of the connections")
    public String dumpUsage(boolean used) {
        StringBuffer out = new StringBuffer();
        List<InternalDbConnection> list = this.pool;
        synchronized (list) {
            for (InternalDbConnection con : this.pool) {
                if (used && !con.isUsed()) continue;
                out.append("--- ").append(con.getClass().getCanonicalName()).append("(").append(con.isUsed() ? "used" : "unused").append(")\n");
                StackTraceElement[] trace = con.getUsedTrace();
                if (trace == null) continue;
                for (StackTraceElement ste : trace) {
                    out.append(ste.getClassName()).append(" ").append(ste.getMethodName()).append("(").append(ste.getFileName()).append(":").append(ste.getLineNumber()).append(")\n");
                }
            }
            this.pool = null;
        }
        return out.toString();
    }

    public boolean isClosed() {
        return this.pool == null;
    }

    private static class Housekeeper
    extends MHousekeeperTask {
        private WeakReference<DbPool> pool;
        private String name;

        private Housekeeper(DbPool pool) {
            this.pool = new WeakReference<DbPool>(pool);
            this.name = pool.getPoolId();
        }

        @Override
        public void doit() throws Exception {
            DbPool obj = (DbPool)this.pool.get();
            if (obj == null || obj.isClosed()) {
                this.log.t(this.name, "close");
                this.cancel();
                return;
            }
            this.log.t(this.getClass(), this.name, "Housekeeping");
            obj.cleanup(false);
        }
    }
}

