/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.sql;

import de.mhus.lib.MException;
import de.mhus.lib.MSingleton;
import de.mhus.lib.logging.Log;
import de.mhus.lib.parser.Parser;
import de.mhus.lib.sql.DbConnection;
import de.mhus.lib.sql.DbPrepared;
import de.mhus.lib.sql.DbStatement;

public class DbConnectionProxy
implements DbConnection {
    private static Log log = Log.getLog(DbConnectionProxy.class);
    private DbConnection instance;
    private long id = MSingleton.instance().nextUniqueId();
    private StackTraceElement[] createStackTrace;

    public DbConnectionProxy(DbConnection instance) {
        if (log.isTrace()) {
            this.createStackTrace = Thread.currentThread().getStackTrace();
            instance.setUsedTrace(this.createStackTrace);
        }
        this.instance = instance;
        log.t(this.id, "created", instance.getInstanceId());
    }

    @Override
    public void commit() throws Exception {
        this.instance.commit();
    }

    @Override
    public boolean isReadOnly() throws Exception {
        return this.instance.isReadOnly();
    }

    @Override
    public void rollback() throws Exception {
        this.instance.rollback();
    }

    @Override
    public DbStatement getStatement(String name) throws MException {
        return this.instance.getStatement(name);
    }

    @Override
    public boolean isClosed() {
        if (this.instance == null) {
            return true;
        }
        return this.instance.isClosed();
    }

    @Override
    public boolean isUsed() {
        return this.instance.isUsed();
    }

    @Override
    public void setUsed(boolean used) {
        if (this.instance == null) {
            return;
        }
        this.instance.setUsed(used);
        if (!used) {
            this.instance = null;
        }
    }

    @Override
    public void close() {
        if (this.instance == null) {
            return;
        }
        log.t(this.id, "close", this.instance.getInstanceId());
        this.setUsed(false);
    }

    protected void finalize() throws Throwable {
        log.t(this.id, "finalized", this.instance.getInstanceId());
        if (this.instance != null) {
            log.d(this.id, "final closed", this.instance.getInstanceId(), this.createStackTrace);
            this.setUsed(false);
        }
        super.finalize();
    }

    @Override
    public DbStatement createStatement(String sql, String language) throws MException {
        return this.instance.createStatement(sql, language);
    }

    @Override
    public long getInstanceId() {
        return this.id;
    }

    @Override
    public Parser createQueryCompiler(String language) throws MException {
        return this.instance.createQueryCompiler(language);
    }

    @Override
    public DbConnection instance() {
        return this.instance;
    }

    @Override
    public DbStatement createStatement(DbPrepared dbPrepared) {
        return this.instance.createStatement(dbPrepared);
    }

    @Override
    public void setUsedTrace(StackTraceElement[] createStackTrace) {
    }

    @Override
    public StackTraceElement[] getUsedTrace() {
        return this.createStackTrace;
    }

    @Override
    public String getDefaultLanguage() {
        return this.instance.getDefaultLanguage();
    }

    @Override
    public String[] getLanguages() {
        return this.instance.getLanguages();
    }

    @Override
    public DbStatement createStatement(String sql) throws MException {
        return this.instance.createStatement(sql);
    }
}

