/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.singleton;

import de.mhus.lib.MActivator;
import de.mhus.lib.MException;
import de.mhus.lib.MSingleton;
import de.mhus.lib.MString;
import de.mhus.lib.config.ConfigUtil;
import de.mhus.lib.config.HashConfig;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.config.MConfigFactory;
import de.mhus.lib.jmx.JmxInitializer;
import de.mhus.lib.jmx.MRemoteManager;
import de.mhus.lib.lang.DynamicClassLoader;
import de.mhus.lib.logging.ConsoleFactory;
import de.mhus.lib.logging.Log;
import de.mhus.lib.logging.LogInitializer;
import de.mhus.lib.logging.MLog;
import de.mhus.lib.persistence.DefaultPersistence;
import de.mhus.lib.persistence.MPersistenceManager;
import java.io.File;
import java.lang.reflect.Method;

public class Standalone
extends MSingleton {
    public static Standalone initialize(String[] args, String configFile) {
        MLog.t("Initialize");
        Standalone instance = new Standalone();
        if (args != null) {
            instance.setArguments(args);
        }
        instance.initConfig(configFile);
        Standalone.setInstance(instance);
        MLog.reset();
        instance.initActivator();
        instance.initLogger();
        instance.initJMX();
        instance.initPersistence();
        instance.initInjection();
        return instance;
    }

    @Override
    public synchronized IConfig getConfig() {
        if (this.config == null) {
            String path;
            ConsoleFactory l = new ConsoleFactory("init", System.out);
            l.setTrace(true);
            if (this.defaultConfigFile != null) {
                l.t("Load Config", "default config file", this.defaultConfigFile);
                File f = new File(this.defaultConfigFile);
                try {
                    if (f.exists()) {
                        this.config = MConfigFactory.getInstance().createConfigFor(f);
                    } else {
                        l.t("Load Config", "default config file not exists");
                    }
                }
                catch (Exception e) {
                    l.t("Load Config", e);
                }
            }
            this.getArguments();
            if (this.args != null) {
                String[] a;
                path = this.args.getValue("m_config_file", 0);
                if (path != null) {
                    l.t("Load Config", "config from args", path);
                    try {
                        File f = new File(path);
                        if (f.exists()) {
                            this.config = MConfigFactory.getInstance().createConfigFor(f);
                        } else {
                            l.t("Load Config", "config from args not exists");
                        }
                    }
                    catch (Exception e) {
                        l.t("Load Config", e);
                    }
                }
                for (String a1 : a = this.args.getValues("m_config_arg")) {
                    String k = MString.beforeIndex(a1, '=');
                    String v = MString.afterIndex(a1, '=');
                    try {
                        l.t("Load Config", "Overwrite key from args", k, v);
                        this.config.setString(k, v);
                    }
                    catch (MException e) {
                        // empty catch block
                    }
                }
            } else if (System.getProperty("m_config_file") != null && (path = System.getProperty("m_config_file")) != null) {
                l.t("Load Config", "config from env", path);
                try {
                    File f = new File(path);
                    if (f.exists()) {
                        this.config = MConfigFactory.getInstance().createConfigFor(f);
                    }
                    l.t("Load Config", "config from env not exists");
                }
                catch (Exception e) {
                    l.t("Load Config", e);
                }
            }
            if (this.config == null) {
                l.t("Load Config", "Empty Config");
                this.config = new HashConfig();
            }
        }
        return this.config;
    }

    private Standalone() {
    }

    public void initConfig(String configFile) {
        if (configFile != null) {
            this.setDefaultConfigFile(configFile);
        }
        this.config = null;
    }

    public void initActivator() {
        IConfig cactivator = this.getConfig(MActivator.class, null);
        if (cactivator == null) {
            return;
        }
        this.log().t("Initialize Activator");
        try {
            MActivator acti;
            IConfig cloader = cactivator.getConfig("loader");
            DynamicClassLoader loader = null;
            if (cloader != null) {
                loader = new DynamicClassLoader("main");
                loader.doSetupFromConfig(cloader);
            }
            this.activator = acti = new MActivator(cactivator, loader);
        }
        catch (Throwable t) {
            this.log().w(t);
        }
    }

    protected void initLogger() {
        IConfig clog = this.getConfig(MLog.class, null);
        if (clog == null) {
            return;
        }
        this.log().t("Initialize Logger");
        try {
            Log log;
            IConfig firstLogger = clog.getConfig("logger");
            if (firstLogger != null && (log = LogInitializer.createLogFactroy(firstLogger)) != null) {
                this.setLogFactory(log);
            }
        }
        catch (Throwable t) {
            this.log().w(t);
        }
    }

    protected void initPersistence() {
        IConfig conf = this.getConfig(MPersistenceManager.class, null);
        if (conf == null) {
            return;
        }
        if (!conf.getBoolean("enabled", true)) {
            return;
        }
        this.log().t("Initialize Persistence");
        try {
            String clazz = conf.getExtracted("class", DefaultPersistence.class.getCanonicalName());
            if (clazz != null) {
                MPersistenceManager obj = (MPersistenceManager)this.getActivator().createObject(clazz);
                obj.init(conf);
                if (this.persistence != null) {
                    this.persistence.close();
                }
                this.persistence = obj;
            }
        }
        catch (Throwable t) {
            this.log().w(t);
        }
    }

    protected void initJMX() {
        IConfig cjmx = this.getConfig(MRemoteManager.class, null);
        if (cjmx == null) {
            return;
        }
        this.log().t("Initialize JMX");
        try {
            this.getJmxManager().open();
            JmxInitializer.initialize(cjmx);
        }
        catch (Throwable t) {
            this.log().w(t);
        }
    }

    protected void initInjection() {
        IConfig ci = this.getConfig().getConfig("initialize");
        if (ci == null) {
            return;
        }
        for (IConfig cc : ci.getConfigBundle("start")) {
            String clazz;
            if (!ConfigUtil.checkCondition(cc) || (clazz = cc.getExtracted("class")) == null) continue;
            try {
                Object obj = this.getActivator().createObject(clazz);
                String method = cc.getExtracted("method");
                if (method == null) continue;
                Method me = obj.getClass().getMethod(method, new Class[0]);
                me.invoke(obj, new Object[0]);
            }
            catch (Throwable e) {
                this.log().e("injection", clazz, e);
            }
        }
    }

    public void reloadConfig() {
        this.config = null;
        this.fireConfigChanged();
    }
}

