/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.singleton;

import de.mhus.lib.MPassword;
import de.mhus.lib.MSingleton;
import de.mhus.lib.jmx.JmxManaged;
import de.mhus.lib.jmx.JmxObject;
import de.mhus.lib.singleton.Standalone;

@JmxManaged(descrition="MSingleton management interface")
public class JmxSingleton
extends JmxObject {
    @JmxManaged(descrition="Reload configuration p1=path to config file")
    public void initConfig(String file) {
        ((Standalone)MSingleton.instance()).initConfig(file);
    }

    @JmxManaged(descrition="Reload logger factory from config")
    public void initLogger() {
        ((Standalone)MSingleton.instance()).initLogger();
    }

    @JmxManaged(descrition="Reload default activator from config")
    public void initActivator() {
        ((Standalone)MSingleton.instance()).initActivator();
    }

    @JmxManaged(descrition="reload RemoteManager from config but do not replace it")
    public void initJMX() {
        ((Standalone)MSingleton.instance()).initJMX();
    }

    @JmxManaged(descrition="Initialize injections from config AGAIN!")
    public void initInjection() {
        ((Standalone)MSingleton.instance()).initInjection();
    }

    @JmxManaged(descrition="Reload configuration")
    public void reloadConfig() {
        ((Standalone)MSingleton.instance()).reloadConfig();
    }

    @JmxManaged(descrition="Call System.exit, give the secret from configuration for security. p1=return code, p2=secret")
    public void exit(int rc, String secret) {
        if (!MSingleton.instance().hasSuperPrivileges(secret)) {
            return;
        }
        this.log().i("Exit by user request via jmx");
        System.exit(rc);
    }

    @JmxManaged(descrition="This is a simple helpfull function to encode a password on the running system (see MPassword). p1=encoding algorithm, p2=password to encode")
    public String encodePassword(int method, String in) {
        return MPassword.encode(method, in);
    }
}

