/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.resources;

import de.mhus.lib.resources.IResourceProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ZipResourceProvider
implements IResourceProvider {
    private ZipFile zipFile;
    private File file;

    public ZipResourceProvider(File file) throws ZipException, IOException {
        this.file = file;
        this.zipFile = new ZipFile(file);
    }

    @Override
    public long getLastModified(String path) throws IOException {
        return this.zipFile.getEntry(path).getTime();
    }

    @Override
    public InputStream getInputStream(String path) throws IOException {
        ZipEntry entry = this.zipFile.getEntry(path);
        if (entry == null) {
            return null;
        }
        return this.zipFile.getInputStream(entry);
    }

    @Override
    public boolean isWriteable(String path) {
        return false;
    }

    @Override
    public OutputStream createFile(String path) throws IOException {
        return null;
    }

    @Override
    public URL getResource(String path) throws IOException {
        URL url = new URL("jar", "", -1, "file://" + this.file.getAbsolutePath() + "!/" + path);
        if (url.openConnection().getContentLength() < 0) {
            return null;
        }
        return url;
    }
}

