/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.resources;

import de.mhus.lib.resources.IResourceProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class PathResourceProvider
implements IResourceProvider {
    private File dir;

    public PathResourceProvider(File base) {
        this.dir = base;
    }

    @Override
    public long getLastModified(String path) throws IOException {
        return new File(this.dir, path).lastModified();
    }

    @Override
    public InputStream getInputStream(String path) throws IOException {
        return new FileInputStream(new File(this.dir, path));
    }

    @Override
    public OutputStream createFile(String path) throws IOException {
        return new FileOutputStream(new File(this.dir, path));
    }

    @Override
    public boolean isWriteable(String path) {
        return new File(this.dir, path).canWrite();
    }

    @Override
    public URL getResource(String path) throws IOException {
        return new File(this.dir, path).toURI().toURL();
    }
}

