/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.resources;

import de.mhus.lib.resources.IResourceProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class ClasspathResourceProvider
implements IResourceProvider {
    private ClassLoader loader;

    public ClasspathResourceProvider() {
        this.loader = this.getClass().getClassLoader();
    }

    public ClasspathResourceProvider(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public OutputStream createFile(String path) throws IOException {
        throw new IOException("Access denied: " + path);
    }

    @Override
    public InputStream getInputStream(String path) throws IOException {
        return this.loader.getResourceAsStream(path);
    }

    @Override
    public long getLastModified(String path) throws IOException {
        return 0L;
    }

    @Override
    public boolean isWriteable(String path) {
        return false;
    }

    @Override
    public URL getResource(String path) {
        return this.loader.getResource(path);
    }
}

