/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.persistence;

import de.mhus.lib.MFile;
import de.mhus.lib.MSystem;
import de.mhus.lib.lang.MObject;
import java.io.File;
import java.io.IOException;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Sample;

public class RoundRobin
extends MObject {
    private RrdDb rrdDb;
    private Sample sample;
    private long lastTime;

    public RoundRobin(long heartbeat, File path) throws IOException {
        if (path == null) {
            path = MFile.createTempFile(MSystem.getPid(), "rrd");
        }
        RrdDef rrdDef = new RrdDef(path.getAbsolutePath());
        rrdDef.setStartTime(System.currentTimeMillis());
        rrdDef.addDatasource("speed", DsType.COUNTER, heartbeat, Double.NaN, Double.NaN);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, 1, 24);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, 6, 10);
        this.rrdDb = new RrdDb(rrdDef);
        this.sample = this.rrdDb.createSample();
    }

    public void add(double value) {
        try {
            long time = System.currentTimeMillis();
            if (time / 1000L == this.lastTime) {
                return;
            }
            this.lastTime = time / 1000L;
            this.sample.setTime(time);
            this.sample.setValues(new double[]{value});
            this.sample.update();
        }
        catch (IOException e) {
            this.log().t(e);
        }
    }

    public String dump() {
        return this.sample.dump();
    }
}

