/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.persistence;

import de.mhus.lib.config.IConfig;
import de.mhus.lib.jmx.JmxManaged;
import de.mhus.lib.jmx.MJmx;
import de.mhus.lib.persistence.Scope;
import java.util.Hashtable;

@JmxManaged(descrition="Application Persistence")
public abstract class MPersistenceManager
extends MJmx {
    private boolean active = false;
    private Hashtable<String, Scope> sessionJmxCache = new Hashtable();

    public abstract void close();

    @JmxManaged(descrition="Flush the changed data into the data store if possible")
    public abstract void flush();

    public abstract void init(IConfig var1) throws Exception;

    public abstract Scope sessionScope();

    public abstract Scope globalScope();

    @JmxManaged
    public abstract Scope getSession(String var1);

    @JmxManaged
    public abstract String[] getSessionIds();

    protected void setActive(boolean active) {
        this.active = active;
    }

    @JmxManaged
    public boolean isActive() {
        return this.active;
    }

    @JmxManaged
    public boolean loadSession(String sessionId) {
        Scope session = this.getSession(sessionId);
        if (session != null) {
            this.sessionJmxCache.put(sessionId, session);
            return true;
        }
        return false;
    }

    @JmxManaged
    public void unloadSession(String sessionId) {
        this.sessionJmxCache.remove(sessionId);
    }
}

