/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.persistence;

import de.mhus.lib.MException;
import de.mhus.lib.MFile;
import de.mhus.lib.MString;
import de.mhus.lib.MXml;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.config.XmlConfigFile;
import de.mhus.lib.jmx.JmxManaged;
import de.mhus.lib.persistence.Scope;
import java.io.File;
import java.util.LinkedList;
import java.util.WeakHashMap;
import org.w3c.dom.Element;

public class DefaultScope
extends Scope {
    private File dir;
    private WeakHashMap<String, XmlConfigFile> cache = new WeakHashMap();

    public DefaultScope(File dir) {
        this.dir = dir;
        this.log().t(this.getSessionId(), "directory", dir);
    }

    public void close() {
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        DefaultScope defaultScope = this;
        synchronized (defaultScope) {
            for (XmlConfigFile config : this.cache.values()) {
                try {
                    config.save();
                }
                catch (MException e) {
                    this.log().w(config, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IConfig getPersistence(String name) {
        DefaultScope defaultScope = this;
        synchronized (defaultScope) {
            XmlConfigFile config = this.cache.get(name);
            if (config == null) {
                try {
                    config = new XmlConfigFile(new File(this.dir, "config_" + MFile.normalize(name) + ".xml"));
                    this.cache.put(name, config);
                }
                catch (Throwable t) {
                    this.log().w(this.dir, name, t);
                }
            }
            return config;
        }
    }

    @Override
    public File getPersistenceFile(String name) {
        return new File(this.dir, "file_" + MFile.normalize(name));
    }

    public File getFile() {
        return this.dir;
    }

    @Override
    public boolean isPersistenceFile() {
        return true;
    }

    @Override
    public String[] getPersistenceNames() {
        LinkedList<String> out = new LinkedList<String>();
        for (File f : this.dir.listFiles()) {
            if (!f.isFile() || !f.getName().startsWith("config_")) continue;
            out.add(MString.beforeLastIndex(MString.afterIndex(f.getName(), '_'), '.'));
        }
        return out.toArray(new String[out.size()]);
    }

    @Override
    public String[] getPersistenceFileNames() {
        LinkedList<String> out = new LinkedList<String>();
        for (File f : this.dir.listFiles()) {
            if (!f.isFile() || !f.getName().startsWith("file_")) continue;
            out.add(MString.afterIndex(f.getName(), '_'));
        }
        return out.toArray(new String[out.size()]);
    }

    @Override
    public String getSessionId() {
        if (this.dir.getName().startsWith("session_")) {
            return MString.afterIndex(this.dir.getName(), '_');
        }
        return "global";
    }

    @JmxManaged
    public String getPersistentFilePath(String name) {
        File f = this.getPersistenceFile(name);
        return f.exists() ? f.getAbsolutePath() : null;
    }

    @JmxManaged
    public String dumpPersistentConfig(String name) {
        IConfig p = this.getPersistence(name);
        if (p == null) {
            return null;
        }
        Element e = ((XmlConfigFile)p).getXmlElement();
        try {
            return "<pre>" + MXml.encode(MXml.toString(e, true)).replaceAll("&quot; ", "&quot; \n") + "</pre>";
        }
        catch (Exception e1) {
            return null;
        }
    }
}

