/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.persistence;

import de.mhus.lib.MCast;
import de.mhus.lib.MFile;
import de.mhus.lib.MSingleton;
import de.mhus.lib.MString;
import de.mhus.lib.MSystem;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.persistence.DefaultScope;
import de.mhus.lib.persistence.MPersistenceManager;
import de.mhus.lib.persistence.Scope;
import java.io.File;
import java.util.Date;
import java.util.LinkedList;

public class DefaultPersistence
extends MPersistenceManager {
    private DefaultScope global;
    private DefaultScope session;

    @Override
    public void flush() {
        this.global.flush();
        this.session.flush();
    }

    @Override
    public void init(IConfig config) {
        String path = config.getExtracted("path");
        File globalDir = path == null ? new File(MSingleton.instance().getApplicationDirectory(), "persistence") : new File(path);
        globalDir.mkdirs();
        if (!globalDir.exists() || !globalDir.canWrite()) {
            this.log().w("Persistence not possible", globalDir);
            return;
        }
        File sessionDir = new File(globalDir, "session_" + MFile.normalize(MCast.toIsoDateTime(new Date())) + "_" + MSystem.getPid());
        sessionDir.mkdirs();
        if (!sessionDir.exists() || !sessionDir.canWrite()) {
            this.log().w("Persistence not possible", sessionDir);
            return;
        }
        this.global = new DefaultScope(globalDir);
        this.session = new DefaultScope(sessionDir);
        this.setActive(true);
    }

    @Override
    public void close() {
        this.setActive(false);
        this.global.close();
        this.session.close();
    }

    @Override
    public Scope sessionScope() {
        return this.session;
    }

    @Override
    public Scope globalScope() {
        return this.global;
    }

    @Override
    public Scope getSession(String sessionId) {
        sessionId = MFile.normalize(sessionId);
        File sessionDir = new File(this.global.getFile(), "session_" + sessionId);
        if (!sessionDir.exists() || !sessionDir.isDirectory()) {
            return null;
        }
        return new DefaultScope(sessionDir);
    }

    @Override
    public String[] getSessionIds() {
        LinkedList<String> out = new LinkedList<String>();
        for (File f : this.global.getFile().listFiles()) {
            if (!f.isDirectory() || !f.getName().startsWith("session_")) continue;
            out.add(MString.afterIndex(f.getName(), '_'));
        }
        return out.toArray(new String[out.size()]);
    }
}

