/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.parser;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;

public class ParseReader {
    private Reader str;
    private char current;
    private boolean closed = false;
    private int pos = -1;

    public ParseReader(Reader str) throws IOException {
        this.str = str;
        this.nextCurrent();
    }

    private void nextCurrent() throws IOException {
        if (this.closed) {
            return;
        }
        int read = this.str.read();
        ++this.pos;
        if (read == -1) {
            this.closed = true;
        }
        this.current = (char)read;
    }

    public char character() throws EOFException {
        if (this.closed) {
            throw new EOFException();
        }
        return this.current;
    }

    public void consume() throws IOException {
        this.nextCurrent();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int getPosition() {
        return this.pos;
    }
}

