/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.logging;

import de.mhus.lib.config.IConfig;
import de.mhus.lib.logging.Log;
import de.mhus.lib.logging.LogInitializer;
import java.util.LinkedList;

public class YLogger
extends Log {
    private Log[] targets;

    public YLogger(IConfig config) throws Exception {
        LinkedList<Log> list = new LinkedList<Log>();
        for (IConfig c : config.getConfigBundle("logger")) {
            Log next = LogInitializer.createLogFactroy(c);
            if (next == null) continue;
            list.add(next);
        }
        this.targets = list.toArray(new Log[list.size()]);
    }

    public YLogger(Log ... targets) {
        this.targets = targets;
    }

    public YLogger(Log[] targets2, String name) {
        this.targets = new Log[targets2.length];
        for (int i = 0; i < this.targets.length; ++i) {
            this.targets[i] = targets2[i].getInstance(name);
            this.targets[i].name = name;
            this.targets[i].update(null, null);
        }
    }

    public YLogger(Log[] targets2, Class<?> clazz) {
        this.targets = new Log[targets2.length];
        for (int i = 0; i < this.targets.length; ++i) {
            this.targets[i] = targets2[i].getInstance(clazz);
            this.targets[i].name = clazz.getCanonicalName();
            this.targets[i].update(null, null);
        }
    }

    @Override
    public void warn(Object message, Throwable t) {
        for (Log log2 : this.targets) {
            log2.warn(message, t);
        }
    }

    @Override
    public void warn(Object message) {
        for (Log log2 : this.targets) {
            log2.warn(message);
        }
    }

    @Override
    public void trace(Object message, Throwable t) {
        for (Log log2 : this.targets) {
            log2.trace(message, t);
        }
    }

    @Override
    public void trace(Object message) {
        for (Log log2 : this.targets) {
            log2.trace(message);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        for (Log log2 : this.targets) {
            if (!log2.isWarnEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTraceEnabled() {
        for (Log log2 : this.targets) {
            if (!log2.isTraceEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInfoEnabled() {
        for (Log log2 : this.targets) {
            if (!log2.isInfoEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFatalEnabled() {
        for (Log log2 : this.targets) {
            if (!log2.isFatalEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isErrorEnabled() {
        for (Log log2 : this.targets) {
            if (!log2.isErrorEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDebugEnabled() {
        for (Log log2 : this.targets) {
            if (!log2.isDebugEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void info(Object message, Throwable t) {
        for (Log log2 : this.targets) {
            log2.info(message, t);
        }
    }

    @Override
    public void info(Object message) {
        for (Log log2 : this.targets) {
            log2.info(message);
        }
    }

    @Override
    public Log getInstance(String name) {
        return new YLogger(this.targets, name);
    }

    @Override
    public Log getInstance(Class<?> clazz) {
        return new YLogger(this.targets, clazz);
    }

    @Override
    public void fatal(Object message, Throwable t) {
        for (Log log2 : this.targets) {
            log2.fatal(message, t);
        }
    }

    @Override
    public void fatal(Object message) {
        for (Log log2 : this.targets) {
            log2.fatal(message);
        }
    }

    @Override
    public void error(Object message, Throwable t) {
        for (Log log2 : this.targets) {
            log2.error(message, t);
        }
    }

    @Override
    public void error(Object message) {
        for (Log log2 : this.targets) {
            log2.error(message);
        }
    }

    @Override
    public void debug(Object message, Throwable t) {
        for (Log log2 : this.targets) {
            log2.debug(message, t);
        }
    }

    @Override
    public void debug(Object message) {
        for (Log log2 : this.targets) {
            log2.debug(message);
        }
    }

    @Override
    public void setTrace(boolean localTrace) {
        super.setTrace(localTrace);
        for (Log log2 : this.targets) {
            log2.setTrace(localTrace);
        }
    }
}

