/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.logging;

import de.mhus.lib.config.IConfig;
import de.mhus.lib.config.XmlConfig;
import de.mhus.lib.logging.Log;
import de.mhus.lib.logging.MLog;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.w3c.dom.Element;

public final class Log4JFactory
extends Log {
    private static final boolean is12 = Priority.class.isAssignableFrom(Level.class);
    private static final String FQCN = Log4JFactory.class.getName();
    private String name;
    private Logger logger;

    public Log4JFactory(IConfig config) {
        if (config != null) {
            IConfig ccc = config.getConfig("configuration");
            String configFile = config.getExtracted("configuration");
            if (ccc != null && ccc instanceof XmlConfig) {
                MLog.t("configure inline");
                DOMConfigurator.configure((Element)((XmlConfig)ccc).getXmlElement());
            } else if (configFile != null) {
                if (configFile.endsWith(".properties")) {
                    MLog.t("configure properties", configFile);
                    PropertyConfigurator.configureAndWatch((String)configFile);
                } else if (configFile.endsWith(".xml")) {
                    MLog.t("configure xml", configFile);
                    DOMConfigurator.configureAndWatch((String)configFile);
                }
            }
        }
    }

    public Log4JFactory() {
    }

    private Log4JFactory(Logger logger) {
        this.name = logger.getName();
        this.logger = logger;
    }

    @Override
    public Log getInstance(Class<?> clazz) {
        Log4JFactory instance = new Log4JFactory(Logger.getLogger(clazz));
        return instance;
    }

    @Override
    public Log getInstance(String name) {
        Log4JFactory instance = new Log4JFactory(Logger.getLogger((String)name));
        return instance;
    }

    @Override
    public void trace(Object message) {
        if (!this.isTrace()) {
            return;
        }
        if (is12) {
            this.getLogger().log(FQCN, (Priority)Level.DEBUG, message, null);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.DEBUG, message, null);
        }
    }

    @Override
    public void trace(Object message, Throwable t) {
        if (!this.isTrace()) {
            return;
        }
        if (is12) {
            this.getLogger().log(FQCN, (Priority)Level.DEBUG, message, t);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.DEBUG, message, t);
        }
    }

    @Override
    public void debug(Object message) {
        if (is12) {
            this.getLogger().log(FQCN, (Priority)Level.DEBUG, message, null);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.DEBUG, message, null);
        }
    }

    @Override
    public void debug(Object message, Throwable t) {
        if (is12) {
            this.getLogger().log(FQCN, (Priority)Level.DEBUG, message, t);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.DEBUG, message, t);
        }
    }

    @Override
    public void info(Object message) {
        if (is12) {
            this.getLogger().log(FQCN, (Priority)Level.INFO, message, null);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.INFO, message, null);
        }
    }

    @Override
    public void info(Object message, Throwable t) {
        if (is12) {
            this.getLogger().log(FQCN, (Priority)Level.INFO, message, t);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.INFO, message, t);
        }
    }

    @Override
    public void warn(Object message) {
        if (is12) {
            this.getLogger().log(FQCN, (Priority)Level.WARN, message, null);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.WARN, message, null);
        }
    }

    @Override
    public void warn(Object message, Throwable t) {
        if (is12) {
            this.getLogger().log(FQCN, (Priority)Level.WARN, message, t);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.WARN, message, t);
        }
    }

    @Override
    public void error(Object message) {
        if (is12) {
            this.getLogger().log(FQCN, (Priority)Level.ERROR, message, null);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.ERROR, message, null);
        }
    }

    @Override
    public void error(Object message, Throwable t) {
        if (is12) {
            this.getLogger().log(FQCN, (Priority)Level.ERROR, message, t);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.ERROR, message, t);
        }
    }

    @Override
    public void fatal(Object message) {
        if (is12) {
            this.getLogger().log(FQCN, (Priority)Level.FATAL, message, null);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.FATAL, message, null);
        }
    }

    @Override
    public void fatal(Object message, Throwable t) {
        if (is12) {
            this.getLogger().log(FQCN, (Priority)Level.FATAL, message, t);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.FATAL, message, t);
        }
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger((String)this.name);
        }
        return this.logger;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        if (is12) {
            return this.getLogger().isEnabledFor((Priority)Level.ERROR);
        }
        return this.getLogger().isEnabledFor((Priority)Level.ERROR);
    }

    @Override
    public boolean isFatalEnabled() {
        if (is12) {
            return this.getLogger().isEnabledFor((Priority)Level.FATAL);
        }
        return this.getLogger().isEnabledFor((Priority)Level.FATAL);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.getLogger().isInfoEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        if (is12) {
            return this.getLogger().isEnabledFor((Priority)Level.WARN);
        }
        return this.getLogger().isEnabledFor((Priority)Level.WARN);
    }
}

