/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.logging;

import de.mhus.lib.MSingleton;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.logging.Log;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Observable;

public class ConsoleFactory
extends Log {
    private String name;
    private PrintStream out;
    private Log.LEVEL level = Log.LEVEL.INFO;
    private boolean traces = true;

    public ConsoleFactory() {
        this.out = System.out;
    }

    public ConsoleFactory(IConfig config) throws FileNotFoundException {
        this.name = config.getExtracted("name", "");
        String newLevel = config.getExtracted("level", null);
        if (newLevel != null) {
            this.level = Log.LEVEL.valueOf(newLevel.toUpperCase());
        }
        String file = config.getExtracted("file", null);
        String io = config.getExtracted("stream", null);
        this.traces = config.getBoolean("traces", true);
        if (file != null) {
            FileOutputStream f = new FileOutputStream(file, config.getBoolean("append", true));
            this.out = new PrintStream(f, true);
        } else {
            this.out = "err".equals(io) ? System.err : System.out;
        }
    }

    public ConsoleFactory(String name, PrintStream stream) {
        this.name = name;
        this.out = stream;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.level = Log.LEVEL.valueOf(MSingleton.instance().getConfig().getString("LEVEL", this.level.name()).toUpperCase());
        super.update(o, arg);
    }

    @Override
    public void debug(Object message) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.out.println("DEBUG: " + this.name + " " + message);
        if (message != null && message instanceof Throwable) {
            ((Throwable)message).printStackTrace(this.out);
        }
    }

    @Override
    public void debug(Object message, Throwable t) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.out.println("DEBUG: " + this.name + " " + message);
        if (t != null && this.traces) {
            t.printStackTrace(this.out);
        }
    }

    @Override
    public void error(Object message) {
        if (!this.isErrorEnabled()) {
            return;
        }
        this.out.println("ERROR: " + this.name + " " + message);
        if (message != null && message instanceof Throwable && this.traces) {
            ((Throwable)message).printStackTrace(this.out);
        }
    }

    @Override
    public void error(Object message, Throwable t) {
        if (!this.isErrorEnabled()) {
            return;
        }
        this.out.println("ERROR: " + this.name + " " + message);
        if (t != null && this.traces) {
            t.printStackTrace(this.out);
        }
    }

    @Override
    public void fatal(Object message) {
        if (!this.isFatalEnabled()) {
            return;
        }
        this.out.println("FATAL: " + this.name + " " + message);
        if (message != null && message instanceof Throwable && this.traces) {
            ((Throwable)message).printStackTrace(this.out);
        }
    }

    @Override
    public void fatal(Object message, Throwable t) {
        if (!this.isFatalEnabled()) {
            return;
        }
        this.out.println("FATAL: " + this.name + " " + message);
        if (t != null && this.traces) {
            t.printStackTrace(this.out);
        }
    }

    @Override
    public Log getInstance(Class<?> clazz) {
        return this.getInstance(clazz.getName());
    }

    @Override
    public Log getInstance(String name) {
        return new ConsoleFactory(name, this.out);
    }

    @Override
    public void info(Object message) {
        if (!this.isInfoEnabled()) {
            return;
        }
        this.out.println("INFO : " + this.name + " " + message);
        if (message != null && message instanceof Throwable && this.traces) {
            ((Throwable)message).printStackTrace(this.out);
        }
    }

    @Override
    public void info(Object message, Throwable t) {
        if (!this.isInfoEnabled()) {
            return;
        }
        this.out.println("INFO : " + this.name + " " + message);
        if (t != null && this.traces) {
            t.printStackTrace(this.out);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.localTrace || this.level.ordinal() <= Log.LEVEL.DEBUG.ordinal();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.localTrace || this.level.ordinal() <= Log.LEVEL.ERROR.ordinal();
    }

    @Override
    public boolean isFatalEnabled() {
        return this.localTrace || this.level.ordinal() <= Log.LEVEL.FATAL.ordinal();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.localTrace || this.level.ordinal() <= Log.LEVEL.INFO.ordinal();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.localTrace || this.level.ordinal() <= Log.LEVEL.TRACE.ordinal();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.localTrace || this.level.ordinal() <= Log.LEVEL.WARN.ordinal();
    }

    @Override
    public void trace(Object message) {
        if (this.isTrace()) {
            this.out.println("TRACE: " + this.name + " " + message);
            if (message != null && message instanceof Throwable && this.traces) {
                ((Throwable)message).printStackTrace(this.out);
            }
        }
    }

    @Override
    public void trace(Object message, Throwable t) {
        if (!this.isTrace()) {
            return;
        }
        this.out.println("TRACE: " + this.name + " " + message);
        if (t != null && this.traces) {
            t.printStackTrace(this.out);
        }
    }

    @Override
    public void warn(Object message) {
        if (!this.isWarnEnabled()) {
            return;
        }
        this.out.println("WARN : " + this.name + " " + message);
        if (message != null && message instanceof Throwable && this.traces) {
            ((Throwable)message).printStackTrace(this.out);
        }
    }

    @Override
    public void warn(Object message, Throwable t) {
        if (!this.isWarnEnabled()) {
            return;
        }
        this.out.println("WARN : " + this.name + " " + message);
        if (t != null && this.traces) {
            t.printStackTrace(this.out);
        }
    }
}

