/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.lang;

import de.mhus.lib.MString;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.logging.Log;
import de.mhus.lib.resources.IResourceProvider;
import de.mhus.lib.resources.PathResourceProvider;
import de.mhus.lib.resources.ZipResourceProvider;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;

public class DynamicClassLoader
extends ClassLoader
implements IResourceProvider {
    public static final Log log = Log.getLog(DynamicClassLoader.class);
    protected String name = null;
    protected LinkedList<IResourceProvider> classLoaders = new LinkedList();
    protected Rule[] rules = null;
    protected RESULT defaultRule = RESULT.NEXT;

    public DynamicClassLoader(String name) {
        this.name = name;
    }

    public DynamicClassLoader(String name, ClassLoader parent) {
        super(parent);
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public void setRules(List<Rule> list) {
        this.rules = list.toArray(new Rule[list.size()]);
    }

    public void addRule(Rule rule) {
        LinkedList<Rule> list = new LinkedList<Rule>();
        if (this.rules != null) {
            for (Rule r : this.rules) {
                list.add(r);
            }
        }
        list.add(rule);
        this.setRules(list);
    }

    public void setDefaultRule(RESULT rule) {
        this.defaultRule = rule;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        log.t("ask for", this, name);
        if (this.rules != null) {
            for (Rule rule : this.rules) {
                RESULT res = rule.check(name);
                switch (res) {
                    case OWN: {
                        return this.findAndOwnClass(name);
                    }
                    case FORWARD: {
                        return super.findClass(name);
                    }
                }
            }
        }
        if (this.defaultRule == RESULT.OWN) {
            return this.findAndOwnClass(name);
        }
        if (this.defaultRule == RESULT.FORWARD) {
            return super.findClass(name);
        }
        String resName = name.replaceAll("\\.", "/") + ".class";
        for (IResourceProvider cl : this.classLoaders) {
            try {
                InputStream res = cl.getInputStream(resName);
                if (res == null) continue;
                log.t("loaded class", this, cl, name);
                return this.toClass(name, res);
            }
            catch (Exception e) {
                log.t(name, e);
            }
        }
        return super.findClass(name);
    }

    public Class<?> findAndOwnClass(String name) throws ClassNotFoundException {
        if (name.startsWith("java.") || name.startsWith("javax.")) {
            return super.loadClass(name);
        }
        String resName = name.replaceAll("\\.", "/") + ".class";
        for (IResourceProvider cl : this.classLoaders) {
            try {
                InputStream res = cl.getInputStream(resName);
                if (res == null) continue;
                log.t("loaded class", this, cl, name);
                return this.toClass(name, res);
            }
            catch (Exception e) {
                log.t(name, e);
            }
        }
        return super.findClass(name);
    }

    private Class<?> toClass(String name, InputStream is) throws ClassNotFoundException {
        try {
            int j;
            ByteArrayOutputStream stream = new ByteArrayOutputStream(1024);
            byte[] buffer = new byte[1024];
            int i = 0;
            while ((j = is.read(buffer, 0, buffer.length)) >= 0) {
                i += j;
                stream.write(buffer, 0, j);
            }
            byte[] binary = stream.toByteArray();
            return this.defineClass(name, binary, 0, binary.length);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    @Override
    protected URL findResource(String name) {
        log.t("resource", this, name);
        for (IResourceProvider cl : this.classLoaders) {
            try {
                URL res = cl.getResource(name);
                if (res == null) continue;
                res.openStream().close();
                log.t("loaded resource", this, cl, name);
                return res;
            }
            catch (Exception e) {
            }
        }
        return super.findResource(name);
    }

    public boolean add(IResourceProvider e) {
        return this.classLoaders.add(e);
    }

    public boolean remove(IResourceProvider o) {
        return this.classLoaders.remove(o);
    }

    public void clear() {
        this.classLoaders.clear();
    }

    public void add(int index, IResourceProvider element) {
        this.classLoaders.add(index, element);
    }

    public void doSetupFromConfig(IConfig config) {
        for (IConfig sub : config.getConfigBundle("resource")) {
            IResourceProvider loader;
            if (sub.isProperty("jar")) {
                String jar = sub.getExtracted("jar");
                log.d("add loader for jar", this, jar);
                try {
                    loader = new ZipResourceProvider(new File(jar));
                    this.add(loader);
                }
                catch (Exception e) {
                    log.w("can't load jar", this, jar);
                }
                continue;
            }
            if (!sub.isProperty("path")) continue;
            String path = sub.getExtracted("path");
            log.d("add loader for path", this, path);
            try {
                loader = new PathResourceProvider(new File(path));
                this.add(loader);
            }
            catch (Exception e) {
                log.w("can't load path", this, path);
            }
        }
        IConfig cRules = config.getConfig("rules");
        if (cRules != null) {
            String def = cRules.getExtracted("default", "OWN").toUpperCase();
            log.d("default rule", this, def);
            this.setDefaultRule(RESULT.valueOf(def));
            LinkedList<Rule> r = new LinkedList<Rule>();
            for (IConfig sub : cRules.getConfigBundle("rule")) {
                log.d("add rule", this, sub.getExtracted("pattern"), sub.getExtracted("result", "FORWARD"));
                r.add(new Rule(sub.getExtracted("pattern"), RESULT.valueOf(sub.getExtracted("result", "FORWARD").toUpperCase())));
            }
            this.setRules(r);
        }
    }

    @Override
    public long getLastModified(String path) throws IOException {
        return 0L;
    }

    @Override
    public InputStream getInputStream(String path) throws IOException {
        return this.getResourceAsStream(path);
    }

    @Override
    public boolean isWriteable(String path) {
        return false;
    }

    @Override
    public OutputStream createFile(String path) throws IOException {
        throw new IOException();
    }

    public static class Rule {
        private String pattern;
        private RESULT result;

        public Rule(String pattern, RESULT result) {
            this.pattern = pattern;
            this.result = result;
        }

        public RESULT check(String name) {
            if (MString.compareFsLikePattern(name, this.pattern)) {
                return this.result;
            }
            return RESULT.NEXT;
        }
    }

    public static enum RESULT {
        NEXT,
        OWN,
        FORWARD;

    }
}

