/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.jpa;

import de.mhus.lib.config.HashConfig;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.jpa.JpaSchema;
import java.util.Properties;

public class JpaProperties
extends Properties {
    protected JpaSchema schema;
    protected IConfig config;
    private static final long serialVersionUID = 1L;

    public JpaProperties(IConfig config) {
        this.config = config;
        IConfig cproperties = config.getConfig("properties");
        if (cproperties != null) {
            for (IConfig prop : cproperties.getConfigBundle("property")) {
                this.setProperty(prop.getExtracted("name"), prop.getExtracted("value"));
            }
        }
    }

    public JpaProperties() {
        this.config = new HashConfig();
    }

    public JpaProperties(Properties arg0) {
        super(arg0);
        this.config = new HashConfig();
    }

    public JpaSchema getSchema() {
        return this.schema;
    }

    public void setSchema(JpaSchema schema) {
        this.schema = schema;
    }

    public void configureTypes() {
        this.setProperty("openjpa.RuntimeUnenhancedClasses", "supported");
        StringBuffer types = null;
        for (Class<?> type : this.schema.getObjectTypes()) {
            if (types == null) {
                types = new StringBuffer();
            } else {
                types.append(";");
            }
            types.append(type.getCanonicalName());
        }
        this.put("openjpa.MetaDataFactory", "jpa(Types=" + types + ")");
        this.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)");
    }

    public IConfig getConfig() {
        return this.config;
    }
}

