/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.jpa;

import de.mhus.lib.jpa.JpaEntityManager;
import de.mhus.lib.jpa.JpaProperties;
import de.mhus.lib.jpa.JpaSchema;
import java.util.Map;
import java.util.UUID;
import javax.persistence.Cache;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.metamodel.Metamodel;

public class JpaManager
implements EntityManagerFactory {
    private JpaSchema schema;
    private JpaProperties properties;
    private EntityManagerFactory entityManagerFactory;
    private UUID unitId;

    public JpaManager(JpaProperties properties) {
        this(properties, null);
    }

    public JpaManager(JpaProperties properties, JpaSchema schema) {
        if (schema != null) {
            properties.setSchema(schema);
        }
        this.schema = properties.getSchema();
        this.properties = properties;
        this.initJpa();
    }

    protected void initJpa() {
        this.unitId = UUID.randomUUID();
        this.schema.doInit(this.properties.getConfig());
        this.properties.configureTypes();
        this.entityManagerFactory = Persistence.createEntityManagerFactory((String)(this.schema.getSchemaName() + "-" + this.unitId.toString()), (Map)this.properties);
        this.schema.doPostInit(this);
    }

    public JpaSchema getSchema() {
        return this.schema;
    }

    public JpaEntityManager createEntityManager() {
        return new JpaEntityManager(this, this.entityManagerFactory, null);
    }

    public void close() {
        if (this.entityManagerFactory == null) {
            return;
        }
        this.entityManagerFactory.close();
        this.entityManagerFactory = null;
    }

    public EntityManager createEntityManager(Map map) {
        return new JpaEntityManager(this, this.entityManagerFactory, map);
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.entityManagerFactory.getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.entityManagerFactory.getMetamodel();
    }

    public boolean isOpen() {
        return this.entityManagerFactory != null && this.entityManagerFactory.isOpen();
    }

    public Map<String, Object> getProperties() {
        return this.entityManagerFactory.getProperties();
    }

    public Cache getCache() {
        return this.entityManagerFactory.getCache();
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this.entityManagerFactory.getPersistenceUnitUtil();
    }
}

