/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.jpa;

import de.mhus.lib.jpa.JpaInjection;
import de.mhus.lib.jpa.JpaManager;
import de.mhus.lib.jpa.JpaQuery;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.Metamodel;
import org.apache.openjpa.persistence.OpenJPAEntityManager;

public class JpaEntityManager
implements EntityManager {
    private JpaManager manager;
    private EntityManager entityManager;

    public JpaEntityManager(JpaManager manager, EntityManagerFactory factory, Map map) {
        this.manager = manager;
        this.entityManager = factory.createEntityManager(map);
    }

    public <T> T injectObject(T object) {
        if (object != null && object instanceof JpaInjection) {
            ((JpaInjection)object).doInjectJpa(this);
        }
        return object;
    }

    public JpaManager getManager() {
        return this.manager;
    }

    public void close() {
        if (this.entityManager == null) {
            return;
        }
        this.entityManager.close();
        this.entityManager = null;
    }

    public void persist(Object entity) {
        this.injectObject(entity);
        this.entityManager.persist(entity);
    }

    public <T> T merge(T entity) {
        this.injectObject(entity);
        return (T)this.entityManager.merge(entity);
    }

    public void remove(Object entity) {
        this.injectObject(entity);
        this.entityManager.remove(entity);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return (T)this.injectObject(this.entityManager.find(entityClass, primaryKey));
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        return (T)this.injectObject(this.entityManager.find(entityClass, primaryKey, properties));
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        return (T)this.injectObject(this.entityManager.find(entityClass, primaryKey, lockMode));
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        return (T)this.entityManager.find(entityClass, primaryKey, lockMode, properties);
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        return (T)this.injectObject(this.entityManager.getReference(entityClass, primaryKey));
    }

    public void flush() {
        this.entityManager.flush();
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.entityManager.setFlushMode(flushMode);
    }

    public FlushModeType getFlushMode() {
        return this.entityManager.getFlushMode();
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.injectObject(entity);
        this.entityManager.lock(entity, lockMode);
    }

    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.injectObject(entity);
        this.entityManager.lock(entity, lockMode, properties);
    }

    public void refresh(Object entity) {
        this.injectObject(entity);
        this.entityManager.refresh(entity);
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.injectObject(entity);
        this.entityManager.refresh(entity, properties);
    }

    public void refresh(Object entity, LockModeType lockMode) {
        this.injectObject(entity);
        this.entityManager.refresh(entity, lockMode);
    }

    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.injectObject(entity);
        this.entityManager.refresh(entity, lockMode, properties);
    }

    public void clear() {
        this.entityManager.clear();
    }

    public void detach(Object entity) {
        this.injectObject(entity);
        this.entityManager.detach(entity);
    }

    public boolean contains(Object entity) {
        this.injectObject(entity);
        return this.entityManager.contains(entity);
    }

    public LockModeType getLockMode(Object entity) {
        this.injectObject(entity);
        return this.entityManager.getLockMode(entity);
    }

    public void setProperty(String propertyName, Object value) {
        this.entityManager.setProperty(propertyName, value);
    }

    public Map<String, Object> getProperties() {
        return this.entityManager.getProperties();
    }

    public JpaQuery<?> createQuery(String qlString) {
        return new JpaQuery(this, this.entityManager.createQuery(qlString));
    }

    public <T> JpaQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        return new JpaQuery(this, (Query)this.entityManager.createQuery(criteriaQuery));
    }

    public <T> JpaQuery<T> createQuery(String qlString, Class<T> resultClass) {
        return new JpaQuery(this, (Query)this.entityManager.createQuery(qlString, resultClass));
    }

    public Query createNamedQuery(String name) {
        return new JpaQuery(this, this.entityManager.createNamedQuery(name));
    }

    public <T> JpaQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        return new JpaQuery(this, (Query)this.entityManager.createNamedQuery(name, resultClass));
    }

    public Query createNativeQuery(String sqlString) {
        return this.entityManager.createNativeQuery(sqlString);
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        return this.entityManager.createNativeQuery(sqlString, resultClass);
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        return this.entityManager.createNativeQuery(sqlString, resultSetMapping);
    }

    public void joinTransaction() {
        this.entityManager.joinTransaction();
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this.injectObject(this.entityManager.unwrap(cls));
    }

    public Object getDelegate() {
        return this.entityManager.getDelegate();
    }

    public boolean isOpen() {
        return this.entityManager != null && this.entityManager.isOpen();
    }

    public EntityTransaction getTransaction() {
        return this.entityManager.getTransaction();
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.entityManager.getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.entityManager.getMetamodel();
    }

    public void begin() {
        this.getTransaction().begin();
    }

    public void commit() {
        this.getTransaction().commit();
    }

    public void rollback() {
        this.getTransaction().rollback();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.manager;
    }

    public <T> T copy(T object) {
        return (T)this.injectObject(((OpenJPAEntityManager)this.entityManager).detachCopy(object));
    }
}

