/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.jmx;

import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.HtmlAdaptorServer;
import de.mhus.lib.MCast;
import de.mhus.lib.MHousekeeperTask;
import de.mhus.lib.MPassword;
import de.mhus.lib.MSingleton;
import de.mhus.lib.config.HashConfig;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.jmx.JmxObject;
import de.mhus.lib.jmx.JmxPackage;
import de.mhus.lib.jmx.MBeanProxy;
import de.mhus.lib.logging.Log;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class MRemoteManager {
    private static Log log = Log.getLog(MRemoteManager.class);
    private MBeanServer mbs;
    private HashMap<ObjectName, Object> registry = new HashMap();
    private HtmlAdaptorServer server;
    private Housekeeper housekeeper = new Housekeeper(this);

    public MRemoteManager() {
        IConfig config = MSingleton.instance().getConfig(this, new HashConfig());
        MSingleton.instance().getHousekeeper().register(this.housekeeper, config.getLong("housekeeper_sleep", 30000L), true);
    }

    public void register(JmxObject object) throws Exception {
        this.register(object, false);
    }

    public void register(JmxObject object, boolean weak) throws Exception {
        if (object instanceof JmxPackage) {
            ((JmxPackage)object).open(this);
        } else {
            ObjectName on = object.getJmxObjectName();
            this.register(on, object, true, weak);
            object.setJmxRegistered(true);
        }
    }

    public void unregister(JmxObject object) throws Exception {
        if (object instanceof JmxPackage) {
            ((JmxPackage)object).close();
        } else {
            ObjectName on = object.getJmxObjectName();
            this.unregister(on);
            object.setJmxRegistered(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ObjectName name, Object object, boolean capsulate, boolean weak) throws Exception {
        Object proxy = object;
        if (capsulate) {
            proxy = new MBeanProxy(object, null, this, name, weak);
        }
        MRemoteManager mRemoteManager = this;
        synchronized (mRemoteManager) {
            if (this.mbs != null) {
                try {
                    log.t("register", name);
                    this.mbs.registerMBean(proxy, name);
                }
                catch (InstanceAlreadyExistsException e) {
                    if (object instanceof JmxObject) {
                        while (true) {
                            String n = ((JmxObject)object).getJmxName();
                            int pos = n.lastIndexOf(45);
                            int nr = 1;
                            if (pos > 0) {
                                nr = MCast.toint(n.substring(pos + 1), nr) + 1;
                                n = n.substring(0, pos);
                            }
                            ((JmxObject)object).setJmxName(n + "-" + nr);
                            name = ((JmxObject)object).getJmxObjectName();
                            if (proxy instanceof MBeanProxy) {
                                ((MBeanProxy)proxy).setName(name);
                            }
                            try {
                                this.mbs.registerMBean(proxy, name);
                                log.t("renamed", name);
                            }
                            catch (InstanceAlreadyExistsException ex) {
                                continue;
                            }
                            break;
                        }
                    }
                    log.d(name, e);
                    throw e;
                }
                catch (Exception e) {
                    log.d(name, e);
                    throw e;
                }
            }
            this.registry.put(name, proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(ObjectName name) {
        MRemoteManager mRemoteManager = this;
        synchronized (mRemoteManager) {
            this.registry.remove(name);
            if (this.mbs != null) {
                try {
                    log.t("unregister", name);
                    this.mbs.unregisterMBean(name);
                }
                catch (Exception e) {
                    log.i(name, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        MRemoteManager mRemoteManager = this;
        synchronized (mRemoteManager) {
            if (this.mbs != null) {
                return;
            }
            this.mbs = ManagementFactory.getPlatformMBeanServer();
            for (Map.Entry<ObjectName, Object> item : this.registry.entrySet()) {
                try {
                    log.t("register", item.getKey());
                    this.mbs.registerMBean(item.getValue(), item.getKey());
                }
                catch (Exception e) {
                    log.i(item.getKey(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        MRemoteManager mRemoteManager = this;
        synchronized (mRemoteManager) {
            if (this.mbs == null) {
                return;
            }
            for (Map.Entry<ObjectName, Object> item : this.registry.entrySet()) {
                try {
                    log.t("unregister", item.getKey());
                    this.mbs.unregisterMBean(item.getKey());
                }
                catch (Exception e) {
                    log.i(item.getKey(), e);
                }
            }
            this.mbs = null;
        }
    }

    public boolean isOpen() {
        return this.mbs != null;
    }

    public void openServer(IConfig config) {
        if (!this.isOpen() || this.server != null) {
            return;
        }
        this.server = new HtmlAdaptorServer(config.getInt("port", 1098));
        for (IConfig cuser : config.getConfigBundle("user")) {
            this.server.addUserAuthenticationInfo(new AuthInfo(cuser.getExtracted("name"), MPassword.decode(cuser.getExtracted("password"))));
        }
        try {
            this.register(new ObjectName("adaptor:proptocol=HTTP"), this.server, false, false);
            this.server.setMBeanServer(this.mbs);
        }
        catch (Exception e) {
            log.w(e);
            this.server = null;
            return;
        }
        this.server.start();
    }

    public void closeServer() {
        if (this.server == null) {
            return;
        }
        this.server.stop();
        this.server = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() {
        MRemoteManager mRemoteManager = this;
        synchronized (mRemoteManager) {
            for (Map.Entry<ObjectName, Object> item : new HashMap<ObjectName, Object>(this.registry).entrySet()) {
                if (!(item.getValue() instanceof MBeanProxy)) continue;
                ((MBeanProxy)item.getValue()).check();
            }
        }
    }

    private static class Housekeeper
    extends MHousekeeperTask {
        private WeakReference<MRemoteManager> manager;

        private Housekeeper(MRemoteManager manager) {
            this.manager = new WeakReference<MRemoteManager>(manager);
        }

        @Override
        public void doit() throws Exception {
            MRemoteManager obj = (MRemoteManager)this.manager.get();
            if (obj == null) {
                this.log.t("close");
                this.cancel();
                return;
            }
            this.log.t(this.getClass(), "Housekeeping");
            try {
                obj.check();
            }
            catch (Throwable t) {
                this.log.t(t);
            }
        }
    }
}

