/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.jmx;

import de.mhus.lib.MSingleton;
import de.mhus.lib.config.IConfig;
import de.mhus.lib.jmx.JmxObject;
import de.mhus.lib.jmx.MRemoteManager;
import de.mhus.lib.logging.MLog;

public class JmxInitializer {
    public static void initialize(IConfig config) {
        MRemoteManager manager = MSingleton.instance().getJmxManager();
        for (IConfig c : config.getConfigBundle("register")) {
            String clazz = c.getExtracted("class");
            MLog.t("register", clazz);
            try {
                JmxObject obj = (JmxObject)MSingleton.instance().getActivator().createObject(clazz);
                if (c.getBoolean("unregister", false)) {
                    manager.unregister(obj);
                }
                manager.register(obj);
            }
            catch (Throwable t) {
                MLog.w(clazz, t);
            }
        }
        IConfig cserver = config.getConfig("server");
        if (cserver != null) {
            if (cserver.getBoolean("enabled", false)) {
                manager.openServer(cserver);
            } else {
                manager.closeServer();
            }
        }
    }
}

