/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.jmx;

import de.mhus.lib.jmx.JmxDescriptionMBean;
import de.mhus.lib.jmx.JmxManaged;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedList;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;

public class JmxDescritionAnnotations
extends JmxDescriptionMBean {
    public JmxDescritionAnnotations(Object in) throws ClassNotFoundException, IntrospectionException {
        super(in);
    }

    @Override
    protected void analyse(Object in) throws ClassNotFoundException, IntrospectionException {
        String description = "";
        LinkedList<MBeanAttributeInfo> attributes = new LinkedList<MBeanAttributeInfo>();
        LinkedList constructors = new LinkedList();
        LinkedList<MBeanOperationInfo> operations = new LinkedList<MBeanOperationInfo>();
        LinkedList notifications = new LinkedList();
        Class<?> ifc = in.getClass();
        JmxManaged anno = null;
        do {
            if ((anno = ifc.getAnnotation(JmxManaged.class)) != null) continue;
            ifc = ifc.getSuperclass();
        } while (anno == null);
        description = anno.descrition();
        HashSet<String> attr = new HashSet<String>();
        ifc = in.getClass();
        do {
            for (Method m : ifc.getMethods()) {
                String name;
                String n = m.getName();
                anno = m.getAnnotation(JmxManaged.class);
                if (anno == null) continue;
                if (n.startsWith("get") && m.getReturnType() != Void.TYPE && m.getParameterTypes().length == 0) {
                    name = m.getName().substring(3);
                    this.getter.put(name, m);
                    attr.add(name);
                    continue;
                }
                if (n.startsWith("is") && m.getReturnType() == Boolean.TYPE && m.getParameterTypes().length == 0) {
                    name = m.getName().substring(2);
                    this.getter.put(name, m);
                    attr.add(name);
                    continue;
                }
                if (n.startsWith("set") && m.getReturnType() == Void.TYPE && m.getParameterTypes().length == 1) {
                    name = m.getName().substring(3);
                    this.setter.put(name, m);
                    attr.add(name);
                    continue;
                }
                this.methods.put(m.getName(), m);
                operations.add(new MBeanOperationInfo(anno.descrition(), m));
            }
        } while ((ifc = ifc.getSuperclass()) != null);
        for (String name : attr) {
            Method g = (Method)this.getter.get(name);
            Method s = (Method)this.setter.get(name);
            attributes.add(new MBeanAttributeInfo(name, g != null ? g.getAnnotation(JmxManaged.class).descrition() : s.getAnnotation(JmxManaged.class).descrition(), g, s));
        }
        this.info = new MBeanInfo(in.getClass().getName(), description, attributes.toArray(new MBeanAttributeInfo[attributes.size()]), constructors.toArray(new MBeanConstructorInfo[constructors.size()]), operations.toArray(new MBeanOperationInfo[operations.size()]), notifications.toArray(new MBeanNotificationInfo[notifications.size()]));
    }
}

