/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.jmx;

import de.mhus.lib.jmx.JmxDescription;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;

public class JmxDescriptionMBean
extends JmxDescription {
    protected HashMap<String, Method> getter = new HashMap();
    protected HashMap<String, Method> setter = new HashMap();
    protected HashMap<String, Method> methods = new HashMap();
    protected MBeanInfo info;
    private String name;

    public JmxDescriptionMBean(Object in) throws ClassNotFoundException, IntrospectionException {
        this.name = in.getClass().getName();
        this.analyse(in);
    }

    protected void analyse(Object in) throws ClassNotFoundException, IntrospectionException {
        String description = "";
        LinkedList<MBeanAttributeInfo> attributes = new LinkedList<MBeanAttributeInfo>();
        LinkedList constructors = new LinkedList();
        LinkedList<MBeanOperationInfo> operations = new LinkedList<MBeanOperationInfo>();
        LinkedList notifications = new LinkedList();
        String ifcName = in.getClass().getName() + "MBean";
        Class<?> ifc = in.getClass().getClassLoader().loadClass(ifcName);
        HashSet<String> attr = new HashSet<String>();
        for (Method m : ifc.getMethods()) {
            String name;
            String n = m.getName();
            if (n.startsWith("get") && m.getReturnType() != Void.TYPE && m.getParameterTypes().length == 0) {
                name = m.getName().substring(3);
                this.getter.put(name, m);
                attr.add(name);
                continue;
            }
            if (n.startsWith("is") && m.getReturnType() == Boolean.TYPE && m.getParameterTypes().length == 0) {
                name = m.getName().substring(2);
                this.getter.put(name, m);
                attr.add(name);
                continue;
            }
            if (n.startsWith("set") && m.getReturnType() == Void.TYPE && m.getParameterTypes().length == 1) {
                name = m.getName().substring(3);
                this.setter.put(name, m);
                attr.add(name);
                continue;
            }
            this.methods.put(m.getName(), m);
            operations.add(new MBeanOperationInfo("", m));
        }
        for (String name : attr) {
            Method g = this.getter.get(name);
            Method s = this.setter.get(name);
            attributes.add(new MBeanAttributeInfo(name, "", g, s));
        }
        this.info = new MBeanInfo(in.getClass().getName(), description, attributes.toArray(new MBeanAttributeInfo[attributes.size()]), constructors.toArray(new MBeanConstructorInfo[constructors.size()]), operations.toArray(new MBeanOperationInfo[operations.size()]), notifications.toArray(new MBeanNotificationInfo[notifications.size()]));
    }

    public Method getGetter(String attribute) {
        return this.getter.get(attribute);
    }

    public Method getSetter(String attribute) {
        return this.setter.get(attribute);
    }

    public Method getMethod(String actionName) {
        return this.methods.get(actionName);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.info;
    }

    @Override
    public Object getAttribute(Object o, String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Method method = this.getGetter(attribute);
        if (method == null) {
            throw new AttributeNotFoundException(attribute + "@" + this.name);
        }
        try {
            return method.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            throw new ReflectionException(e, attribute + "@" + this.name);
        }
    }

    @Override
    public void setAttribute(Object o, Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Method method = this.getSetter(attribute.getName());
        if (method == null) {
            throw new AttributeNotFoundException(attribute + "@" + this.name);
        }
        try {
            method.invoke(o, attribute.getValue());
        }
        catch (Exception e) {
            throw new ReflectionException(e, attribute + "@" + this.name);
        }
    }

    @Override
    public Object invoke(Object o, String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Method method = this.getMethod(actionName);
        try {
            return method.invoke(o, params);
        }
        catch (Exception e) {
            throw new ReflectionException(e, actionName + "@" + this.name);
        }
    }
}

